<?php
/**
 * Plugin Name: WPDM - Extended Short-codes
 * Plugin URI: https://www.wpdownloadmanager.com/download/wpdm-extended-short-codes/
 * Description: WordPress Download Manager Pro Extended Short-Codes
 * Author: W3 Eden, Inc.
 * Version: 3.0.4
 * Text Domain: wpdm-extended-shortcodes
 * Domain Path: /languages
 * Author URI: https://www.wpdownloadmanager.com/
 * Update URI: wpdm-extended-shortcode
 */

// Exit if accessed directly
use WPDM\__\TempStorage;

if (!defined('ABSPATH')) {
    exit;
}

if (defined('WPDM_VERSION')) {

    /**
     * Handle output for [wpdm_tree category=id download_link=0/1 orderby=title/modified/date order=asc/desc ] shrotcode
     * @param array $params
     * @return array|string|string[]
     */
    function wpdm_tree($params = array()){
        $treejs = plugins_url('/wpdm-extended-shortcodes/js/jqueryFileTree.js');
        $treecss = plugins_url('/wpdm-extended-shortcodes/css/jqueryFileTree.css');
        $siteurl = site_url();
        if(is_array($params)) @extract($params);
        $category = isset($category) ? get_term_by("slug", $category, 'wpdmcategory') : null;
        $category = $category ? $category->term_id : '/';
        $download_link = isset($download_link) ? (int)$download_link : 0;

        $_params = \WPDM\__\Crypt::encrypt($params);

        $orderby = isset($orderby) ? $orderby : 'modified';
        $order = isset($order) ? $order : 'desc';
        $newwin = isset($newwin) && (int)$newwin === 1 ? 'newwin=1' : '';
        $nw = $newwin ? 1 : 0;
        $tid = uniqid();
        $data = <<<TREE
        
        <div id="wpdmtree"></div>
   
    <link rel="stylesheet" href="{$treecss}" />          
    <div id="tree{$tid}"></div>
    <script>
        jQuery( function($) {     
            var nw = {$nw};
            $.getScript('{$treejs}', function() {
              $('#tree{$tid}').fileTree({
                script: '{$siteurl}/?task=wpdm_tree&params={$_params}', 
                expandSpeed: 1000,
                collapseSpeed: 1000,
                root: '{$category}',
                multiFolder: false
            }, function(file) {
               if(nw === 1)
                window.open(file);
                else
                location.href = file;              
            });
            });
            
        });
    </script>    
TREE;

        return str_replace(array("\n","\r"),"", $data);
    }

    function wpdm_slider($params = array())
    {
        $ids = "";
        extract($params);
        $ids = explode(",", $ids);
        ob_start();
        include __DIR__.'/templates'.WPDM()->bsversion.'/slider.php';
        $data = ob_get_clean();
        return $data;
    }

    function wpdm_carousel($params = array())
    {

        static $cccount;
        $cccount++;
        if (is_array($params))
            extract($params);
        if (isset($category)) {
            if(intval($category) == 0 && $category != '')
                $cat = get_term_by('slug', $category, 'wpdmcategory');
            else
                $cat = get_term_by('term_id', $category, 'wpdmcategory');
        }
        ob_start();
        $items = wpdm_valueof($params, "items_per_page", ['default' => 3]);
        $items_total = wpdm_valueof($params, "items_total", ['default' => -1]);
        $template = wpdm_valueof($params, "template", ['default' => 'link-template-panel']);
        $autoplay = wpdm_valueof($params, "autoplay", ['default' => 0, 'validate' => 'int']);
        $nav = wpdm_valueof($params, "nav", ['default' => 0, 'validate' => 'int']);
        $dots = wpdm_valueof($params, "dots", ['default' => 1, 'validate' => 'int']);
        $wrap = wpdm_valueof($params, "wrap", ['default' => 1, 'validate' => 'int']);
        ?>
        <script>
            jQuery(function ($){
                <?php if($cccount < 2) { ?>
                var basecss = WPDM.el("link", {rel: "stylesheet", href: "<?= plugins_url("owlcarousel/assets/owl.carousel.min.css", __FILE__) ?>"});
                var themecss = WPDM.el("link", {rel: "stylesheet", href: "<?= plugins_url("owlcarousel/assets/owl.theme.default.min.css", __FILE__) ?>"});
                $('head').append(basecss).append(themecss);
                <?php } ?>
                $.getScript("<?= plugins_url("owlcarousel/owl.carousel.min.js", __FILE__) ?>", function () {
                    $("#wpdm-carousel-<?= $cccount; ?>").owlCarousel({
                        margin:15,
                        items: <?= $items ?>,
                        autoplay: <?= $autoplay ?>,
                        dots: <?= $dots ?>,
                        nav: <?= $nav ?>
                    });
                });
            });
        </script>
        <div class="w3eden">
        <?php if($wrap === 1) { ?>
        <div class="card">
            <div class="card-header">
                <div class="media">
                    <div class="media-body">
                        <h3 class="m-0 p-0"><?php echo isset($category) ? $cat->name : 'New Downloads'; ?></h3>
                    </div>
                    <div class="ml-3">
                        <?php if (isset($category)): ?><a class="btn btn-xs btn-secondary btn-transparent"
                                                          title='View All'  href="<?php echo get_term_link($cat); ?>"
                                                          data-slide="next"><i class="fa fa-white fa-th"></i>
                            </a><?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="card-body">
            <?php } ?>
            <div id="wpdm-carousel-<?= $cccount; ?>" class="wpdm-carousel owl-carousel owl-theme">
                <?php
                $params = array(
                    'post_type' => 'wpdmpro',
                    'posts_per_page' => $items_total
                );
                if (isset($category))
                    $params['tax_query'] = array(array(
                        'taxonomy' => 'wpdmcategory',
                        'field' => 'slug',
                        'terms' => array($cat->slug)
                    ));
                $packs = get_posts($params);
                foreach ($packs as $file) {
                    echo \WPDM\__\UI::div(do_shortcode("[wpdm_package id='{$file->ID}' template='{$template}']"), 'item');
                }
                ?>

            </div>
                <?php if($wrap === 1) { ?>
            </div>
        </div>
        <?php } ?>
        </div>

        <?php
        $data = ob_get_clean();

        return $data;
    }


    function wpdm_embed_tree(){

        if (wpdm_query_var('task', 'txt') != 'wpdm_tree') return;
        global $wpdb;

        $sc_params = \WPDM\__\Crypt::decrypt(wpdm_query_var('params'), true);

        if(!is_array($sc_params)) $sc_params = array();

        $tparams = array( 'hide_empty' => false);
        $tparams['orderby'] =  isset($sc_params['cat_orderby']) && $sc_params['cat_orderby'] !== '' ? $sc_params['cat_orderby'] : 'name';
        $tparams['order'] =  isset($sc_params['cat_order']) && $sc_params['cat_order'] !== '' ? $sc_params['cat_order'] : 'desc';
        $cats = get_terms( 'wpdmcategory', $tparams );


        $newwin = isset($sc_params['newwin']) && (int)$sc_params['newwin'] === 1 ? 'target=_blank' : '';

        echo "<ul class='jqueryFileTree' style='display: none;'>";
        // All Cats
        $scat = wpdm_query_var('dir') == '/' ? '' : wpdm_query_var('dir', 'txt');
        $hide_all = (int)WPDM()->setting->get('_wpdm_hide_all', 0);
        foreach ($cats as $id => $cat) {

            // Only categories with explicit role access will be shown
             //if( ! wpdm_user_has_access( $cat->term_id ,'') ) continue;
            if(!\WPDM\Category\CategoryController::userHasAccess($cat->term_id) && $hide_all === 1) continue;

            if ($cat->parent == intval($scat))
                echo "<li class='directory collapsed'><a href='#' rel='" . $cat->term_id . "'>" . $cat->name . "</a></li>";
        }

        // All files
        $params = array(
            'post_type' => 'wpdmpro',
            'posts_per_page' => 9999
        );

        if($scat == ''){
            $params['tax_query'] = array(
                array(
                    'taxonomy' => 'wpdmcategory',
                    'field' => 'term_id',
                    'terms' => get_terms( 'wpdmcategory', array( 'fields' => 'ids'  ) ),
                    'operator' => 'NOT IN',
                )
            );
        } else {
            $params['tax_query'] = array(
                array(
                    'taxonomy' => 'wpdmcategory',
                    'field' => 'term_id',
                    'terms' => $scat,
                    'include_children' => false
                )
            );
        }

        $params['orderby'] = isset($sc_params['orderby']) && $sc_params['orderby'] !== '' ? $sc_params['orderby'] : 'date';
        $params['order'] = isset($sc_params['order']) && $sc_params['order'] !== '' ? $sc_params['order'] : 'desc';
        $download_link = isset($sc_params['download_link']) ? (int)$sc_params['download_link'] : 0;
        $packs = new WP_Query($params);

        while ($packs->have_posts()) {
            $packs->the_post();

            $files = maybe_unserialize(get_post_meta(get_the_ID(), '__wpdm_files', true));

            if ( is_array($files) && count($files) == 1 ) {
                $tfiles = $files;
                $file = array_shift($tfiles);
                $ext = explode(".", $file);
                $ext = end($ext);
            }

            if (!is_array($files) || count($files) == 0) {
                $ext = '_blank';
            }

            if ( is_array($files) && count($files) > 1 ) $ext = 'zip';

            $icon = WPDM()->package->icon(get_the_ID());

            if(wpdm_user_has_access(get_the_ID())) {
                if ($download_link === 0 || wpdm_is_locked(get_the_ID()))
                    echo "<li  class='file ext_$ext' style='background: url($icon) left center no-repeat;background-size: 16px;'><a {$newwin} href='" . get_permalink(get_the_ID()) . "' rel='" . get_permalink(get_the_ID()) . "'>" . get_the_title() . "</a></li>";
                else
                    echo "<li  class='file ext_$ext' style='background: url($icon) left center no-repeat;background-size: 16px;'><a {$newwin} href='" . wpdm_download_url(get_the_ID()) . "' rel='" . wpdm_download_url(get_the_ID()) . "'>" . get_the_title() . "</a></li>";
            }
        }
        echo "</ul>";

        die();
    }

    function wpdm_popup_link_tag($vars){
        $vars['popup_link'] = "<a class='wpdm-popup-link' data-title='".$vars['title']."'  data-toggle='modal' data-target='#wpdm-popup-link' href='" . get_permalink($vars['ID']) . "'>" . $vars['title'] . "</a>";
        return $vars;
    }

    function wpdm_popup_link(){
        if(is_singular('wpdmpro') || wpdm_query_var('embed')  !== '') return;
        ?>
        <div class="w3eden">
            <div id="wpdm-popup-link" class="modal fade">
                <div class="modal-dialog" style="width: 750px">
                    <div class="modal-content">
                        <div class="modal-header">
                              <h4 class="modal-title"></h4>
                        </div>
                        <div class="modal-body" id='wpdm-modal-body'>
                            <p class="wpdm-placeholder">
                                [ Placeholder content for popup link ]
                                <a href="https://www.wpdownloadmanager.com/">WordPress Download Manager - Best Download Management Plugin</a>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->


        </div>
        <script language="JavaScript">
            <!--
            jQuery(function () {
                jQuery('.wpdm-popup-link').click(function (e) {
                    e.preventDefault();
                    jQuery('#wpdm-popup-link .modal-title').html(jQuery(this).data('title'));
                    jQuery('#wpdm-modal-body').html('<i class="icon"><img align="left" style="margin-top: -1px" src="<?php echo plugins_url('/download-manager/assets/images/loading-new.gif'); ?>" /></i>&nbsp;Please Wait...');
                    jQuery('#wpdm-popup-link').modal('show');
                    jQuery.post(this.href,{mode:'popup'}, function (res) {
                        jQuery('#wpdm-modal-body').html(res);
                    });
                    return false;
                });
            });
            //-->
        </script>
        <style type="text/css">
            #wpdm-modal-body img {
                max-width: 100% !important;
            }
            .wpdm-placeholder{
                display: none;
            }
        </style>
    <?php
    }

    function wpdm_popup_data(){
        if (isset($_REQUEST['mode']) && $_REQUEST['mode'] == 'popup'){
            global $post;
            $template = get_post_meta($post->ID,'__wpdm_page_template', true);
            echo FetchTemplate($template, $post->ID, 'page');
            die();
        }
    }

    function wpdm_extsc_generate(){
        ?>
     <div class="panel panel-default">
         <div class="panel-heading">Tree View</div>
         <div class="panel-body">
             <?php //wpdm_dropdown_categories('c',0, 'scc'); ?>
             <?php
                 wp_dropdown_categories(
                     array(
                         'show_option_none' => __('Select category', 'wpdmpro'),
                         'show_count' => 0,
                         'orderby' => 'name',
                         'echo' => 1,
                         'class' => 'form-control selectpicker',
                         'taxonomy' => 'wpdmcategory',
                         'hide_empty' => 0,
                         'name' => 'c',
                         'id' => 'scc' ,
                         'selected' => 0,
                         'value_field' => 'slug',
                     )
                 );
             ?>

             <label><input type="checkbox" id="tvddl"> Direct Download Link</label>

             <button class="btn btn-primary btn-sm" id="tvw">Insert to Post</button>
             <script>
                 jQuery('#tvw').click(function(){

                     var cats = jQuery('#scc').val()!='-1'?' category="' + jQuery('#scc').val() + '" ':'';
                     var tvddl = jQuery('#tvddl').prop('checked')?' download_link=1':'';
                     var win = window.dialogArguments || opener || parent || top;
                     win.send_to_editor('[wpdm_tree' + cats + tvddl + ']');
                     tinyMCEPopup.close();
                     return false;
                 });
             </script>

         </div>
         <div class="panel-heading">Carousel</div>
         <div class="panel-body">
             <?php wpdm_dropdown_categories('c',0, 'scc1'); ?>  <button class="btn btn-primary btn-sm" id="crs">Insert to Post</button>
             <script>
                 jQuery('#crs').click(function(){
                     if(jQuery('#pids').val()=='-1'){
                         alert("Select Category!");
                         return false;
                     }
                     cats = jQuery('#scc1').val()!='-1'?' category="' + jQuery('#scc1').val() + '" ':'';
                     var win = window.dialogArguments || opener || parent || top;
                     win.send_to_editor('[wpdm_carousel' + cats + ']');
                     tinyMCEPopup.close();
                     return false;
                 });
             </script>
         </div>
         <div class="panel-heading">Slider</div>
         <div class="panel-body">
             <input type="text" id="pids" placeholder="Package IDs separated by comma" style="width: 250px;display: inline" class="form-control input-sm" value="" />
             <button class="btn btn-primary btn-sm" id="sld">Insert to Post</button>
             <script>
                 jQuery('#sld').click(function(){
                     if(jQuery('#pids').val()==''){
                         alert("Enter package ids separate by comma!");
                         return false;
                     }
                     var win = window.dialogArguments || opener || parent || top;
                     win.send_to_editor('[wpdm_slider ids="'+jQuery('#pids').val()+'"]');
                     tinyMCEPopup.close();
                     return false;
                 });
             </script>
         </div>
     </div>
    <?php
    }



    add_action('init', 'wpdm_embed_tree');
    add_action('wpdm_ext_shortcode', 'wpdm_extsc_generate');

    add_shortcode('wpdm_tree', 'wpdm_tree');
    add_shortcode('wpdm_slider', 'wpdm_slider');
    add_shortcode('wpdm_carousel', 'wpdm_carousel');
    add_filter('wdm_before_fetch_template', 'wpdm_popup_link_tag');

    add_filter('wp_footer', 'wpdm_popup_link');
    add_action("wp", "wpdm_popup_data");

    add_filter("wpdm_addon_update", function ( $addons ) {
        if( ! function_exists('get_plugin_data') ){
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
        $data = get_plugin_data(__FILE__);
        $data['File'] = __FILE__;
        $data['download_url'] = 'https://www.wpdownloadmanager.com/?wpdmdl=15691';
        return $addons;
    });

    add_filter("update_plugins_wpdm-extended-shortcode", function ($update, $plugin_data, $plugin_file, $locales){
        $id = 'wpdm-extended-shortcodes';
        $latest_versions = WPDM()->updater->getLatestVersions();
        $latest_version = wpdm_valueof($latest_versions, $id);
        $update = [];
        $update['id']           = $id;
        $update['slug']         = $id;
        $update['url']          = 'https://www.wpdownloadmanager.com/download/wpdm-extended-short-codes/';
        $update['tested']       = true;
        $update['version']      = $latest_version;
        $update['package'] = 'https://www.wpdownloadmanager.com/?wpdmdl=15691';
        return $update;
    }, 10, 4);

}
