/*
 * Decompiled with CFR 0.152.
 */
package bin.zip.encoding;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class DetectEncoding {
    private static final int UTF8 = 0;
    private static final int GB2312 = 1;
    private static final int GBK = 2;
    private static final int UNICODE = 3;
    private static final int ASCII = 4;
    private static final int BIG5 = 5;
    private static final int EUC_TW = 6;
    private static final int OTHER = 7;
    private static final int TOTAL_ENCODINGS = 8;
    private static final int[][] GBFreq;
    private static final int[][] GBKFreq;
    private static final int[][] Big5Freq;
    private static final int[][] EUC_TWFreq;
    private static final Charset[] encodeCharset;
    public static final Charset CHARSET_UTF8;
    public static final Charset CHARSET_GB2312;
    public static final Charset CHARSET_GBK;
    public static final Charset CHARSET_UNICODE;
    public static final Charset CHARSET_BIG5;
    public static final Charset CHARSET_EUC_TW;
    int encoding_guess = 7;
    int gb2312_dbchars = 1;
    int gb2312_chars = 1;
    long gb2312_gbfreq = 0L;
    long gb2312_totalfreq = 1L;
    int gbk_dbchars = 1;
    int gbk_chars = 1;
    long gbk_freq = 0L;
    long gbk_totalfreq = 1L;
    int big5_dbchars = 1;
    int big5_chars = 1;
    long big5_freq = 0L;
    long big5_totalfreq = 1L;
    int tw_dbchars = 1;
    int tw_chars = 1;
    long tw_freq = 0L;
    long tw_totalfreq = 1L;
    int goodbytes = 0;
    int asciibytes = 0;
    int utf8Length = 0;
    boolean impossibleUTF16 = false;
    int ascii_score = 70;

    public static String encodeString(byte[] data, boolean mustEncodable) {
        DetectEncoding detectEncoding = new DetectEncoding();
        detectEncoding.update(data);
        if (mustEncodable && detectEncoding.encoding_guess == 7) {
            return null;
        }
        Charset charset = detectEncoding.getEncode();
        return new String(data, charset);
    }

    public void update(byte[] rawtext) {
        this.update(rawtext, 0, rawtext.length);
    }

    public void update(byte[] rawtext, int offset, int length) {
        int[] scores = new int[8];
        scores[0] = this.utf8_probability(rawtext, offset, length);
        scores[1] = this.gb2312_probability(rawtext, offset, length);
        scores[2] = this.gbk_probability(rawtext, offset, length);
        scores[3] = this.utf16_probability(rawtext, offset, length);
        scores[4] = this.ascii_probability(rawtext, offset, length);
        scores[5] = this.big5_probability(rawtext, offset, length);
        scores[6] = this.euc_tw_probability(rawtext, offset, length);
        int maxScore = 0;
        for (int index = 0; index < 8; ++index) {
            if (scores[index] <= maxScore) continue;
            this.encoding_guess = index;
            maxScore = scores[index];
        }
        if (maxScore <= 50) {
            this.encoding_guess = 7;
        }
    }

    public Charset getEncode() {
        return encodeCharset[this.encoding_guess];
    }

    public static Charset getEncodeByIndex(int index) {
        return encodeCharset[index];
    }

    public int getEncodeIndex() {
        return this.encoding_guess;
    }

    public static String getEncodeName(int index) {
        switch (index) {
            case 0: {
                return "UTF-8";
            }
            case 1: {
                return "GB2312";
            }
            case 2: {
                return "GBK";
            }
            case 3: {
                return "Unicode";
            }
            case 4: {
                return "ASCII";
            }
            case 5: {
                return "Big5";
            }
            case 6: {
                return "EUC-TW";
            }
        }
        return "UTF-8";
    }

    private int gb2312_probability(byte[] rawtext, int offset, int length) {
        int rawLength = offset + length - 1;
        for (int i = offset; i < rawLength; ++i) {
            if (rawtext[i] >= 0) continue;
            ++this.gb2312_dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++this.gb2312_chars;
                this.gb2312_totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = rawtext[i + 1] + 256 - 161;
                if (GBFreq[row][column] != 0) {
                    this.gb2312_gbfreq += (long)GBFreq[row][column];
                } else if (15 <= row && row < 55) {
                    this.gb2312_gbfreq += 200L;
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)this.gb2312_chars / (float)this.gb2312_dbchars);
        float freqval = 50.0f * ((float)this.gb2312_gbfreq / (float)this.gb2312_totalfreq);
        return (int)(rangeval + freqval);
    }

    private int gbk_probability(byte[] rawtext, int offset, int length) {
        int rawLength = offset + length - 1;
        for (int i = offset; i < rawLength; ++i) {
            int column;
            int row;
            if (rawtext[i] >= 0) continue;
            ++this.gbk_dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -9 && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2) {
                ++this.gbk_chars;
                this.gbk_totalfreq += 500L;
                row = rawtext[i] + 256 - 161;
                column = rawtext[i + 1] + 256 - 161;
                if (GBFreq[row][column] != 0) {
                    this.gbk_freq += (long)GBFreq[row][column];
                } else if (15 <= row && row < 55) {
                    this.gbk_freq += 200L;
                }
            } else if (-127 <= rawtext[i] && rawtext[i] <= -2 && (-128 <= rawtext[i + 1] && rawtext[i + 1] <= -2 || 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126)) {
                ++this.gbk_chars;
                this.gbk_totalfreq += 500L;
                row = rawtext[i] + 256 - 129;
                column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 128;
                if (GBKFreq[row][column] != 0) {
                    this.gbk_freq += (long)GBKFreq[row][column];
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)this.gbk_chars / (float)this.gbk_dbchars);
        float freqval = 50.0f * ((float)this.gbk_freq / (float)this.gbk_totalfreq);
        return (int)(rangeval + freqval) - 1;
    }

    private int big5_probability(byte[] rawtext, int offset, int length) {
        int rawLength = offset + length - 1;
        for (int i = offset; i < rawLength; ++i) {
            if (rawtext[i] >= 0) continue;
            ++this.big5_dbchars;
            if (-95 <= rawtext[i] && rawtext[i] <= -7 && (64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 || -95 <= rawtext[i + 1] && rawtext[i + 1] <= -2)) {
                ++this.big5_chars;
                this.big5_totalfreq += 500L;
                int row = rawtext[i] + 256 - 161;
                int column = 64 <= rawtext[i + 1] && rawtext[i + 1] <= 126 ? rawtext[i + 1] - 64 : rawtext[i + 1] + 256 - 97;
                if (Big5Freq[row][column] != 0) {
                    this.big5_freq += (long)Big5Freq[row][column];
                } else if (3 <= row && row <= 37) {
                    this.big5_freq += 200L;
                }
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)this.big5_chars / (float)this.big5_dbchars);
        float freqval = 50.0f * ((float)this.big5_freq / (float)this.big5_totalfreq);
        return (int)(rangeval + freqval);
    }

    private int euc_tw_probability(byte[] rawtext, int offset, int length) {
        int rawLength = offset + length - 1;
        for (int i = offset; i < rawLength; ++i) {
            if (rawtext[i] >= 0) continue;
            ++this.tw_dbchars;
            if (i + 3 < offset + length && -114 == rawtext[i] && -95 <= rawtext[i + 1] && rawtext[i + 1] <= -80 && -95 <= rawtext[i + 2] && rawtext[i + 2] <= -2 && -95 <= rawtext[i + 3] && rawtext[i + 3] <= -2) {
                ++this.tw_chars;
                i += 3;
                continue;
            }
            if (-95 > rawtext[i] || rawtext[i] > -2 || -95 > rawtext[i + 1] || rawtext[i + 1] > -2) continue;
            ++this.tw_chars;
            this.tw_totalfreq += 500L;
            int row = rawtext[i] + 256 - 161;
            int column = rawtext[i + 1] + 256 - 161;
            if (EUC_TWFreq[row][column] != 0) {
                this.tw_freq += (long)EUC_TWFreq[row][column];
            } else if (35 <= row && row <= 92) {
                this.tw_freq += 150L;
            }
            ++i;
        }
        float rangeval = 50.0f * ((float)this.tw_chars / (float)this.tw_dbchars);
        float freqval = 50.0f * ((float)this.tw_freq / (float)this.tw_totalfreq);
        return (int)(rangeval + freqval);
    }

    private int utf8_probability(byte[] rawtext, int offset, int length) {
        int rawtextlen = offset + length;
        for (int i = offset; i < rawtextlen; ++i) {
            if ((rawtext[i] & 0x7F) == rawtext[i]) {
                ++this.asciibytes;
                continue;
            }
            if (-64 <= rawtext[i] && rawtext[i] <= -33 && i + 1 < rawtextlen && -128 <= rawtext[i + 1] && rawtext[i + 1] <= -65) {
                this.goodbytes += 2;
                ++i;
                continue;
            }
            if (-32 > rawtext[i] || rawtext[i] > -17 || i + 2 >= rawtextlen || -128 > rawtext[i + 1] || rawtext[i + 1] > -65 || -128 > rawtext[i + 2] || rawtext[i + 2] > -65) continue;
            this.goodbytes += 3;
            i += 2;
        }
        if (this.asciibytes == length) {
            return 0;
        }
        this.utf8Length += length - this.asciibytes;
        int score = (int)(100.0f * ((float)this.goodbytes / (float)this.utf8Length));
        if (score > 98) {
            return score;
        }
        if (score > 95 && this.goodbytes > 30) {
            return score;
        }
        this.goodbytes = 0;
        return 0;
    }

    private int utf16_probability(byte[] rawtext, int offset, int length) {
        if (this.impossibleUTF16 || length < 2) {
            return 0;
        }
        if (-2 == rawtext[offset] && -1 == rawtext[offset + 1] || -1 == rawtext[offset] && -2 == rawtext[offset + 1]) {
            return 100;
        }
        this.impossibleUTF16 = true;
        return 0;
    }

    private int ascii_probability(byte[] rawtext, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            byte aRawtext = rawtext[i];
            if (this.ascii_score <= 0) {
                return 0;
            }
            if (aRawtext < 0) {
                this.ascii_score -= 5;
                continue;
            }
            if (aRawtext != 27) continue;
            this.ascii_score -= 5;
        }
        return this.ascii_score;
    }

    static void initialize_frequencies() {
        int j;
        int i;
        for (i = 0; i < 93; ++i) {
            for (j = 0; j < 93; ++j) {
                DetectEncoding.GBFreq[i][j] = 0;
            }
        }
        for (i = 0; i < 126; ++i) {
            for (j = 0; j < 191; ++j) {
                DetectEncoding.GBKFreq[i][j] = 0;
            }
        }
        for (i = 0; i < 93; ++i) {
            for (j = 0; j < 157; ++j) {
                DetectEncoding.Big5Freq[i][j] = 0;
            }
        }
        for (i = 0; i < 93; ++i) {
            for (j = 0; j < 93; ++j) {
                DetectEncoding.EUC_TWFreq[i][j] = 0;
            }
        }
        DetectEncoding.GBFreq[20][35] = 599;
        DetectEncoding.GBFreq[49][26] = 598;
        DetectEncoding.GBFreq[41][38] = 597;
        DetectEncoding.GBFreq[17][26] = 596;
        DetectEncoding.GBFreq[32][42] = 595;
        DetectEncoding.GBFreq[39][42] = 594;
        DetectEncoding.GBFreq[45][49] = 593;
        DetectEncoding.GBFreq[51][57] = 592;
        DetectEncoding.GBFreq[50][47] = 591;
        DetectEncoding.GBFreq[42][90] = 590;
        DetectEncoding.GBFreq[52][65] = 589;
        DetectEncoding.GBFreq[53][47] = 588;
        DetectEncoding.GBFreq[19][82] = 587;
        DetectEncoding.GBFreq[31][19] = 586;
        DetectEncoding.GBFreq[40][46] = 585;
        DetectEncoding.GBFreq[24][89] = 584;
        DetectEncoding.GBFreq[23][85] = 583;
        DetectEncoding.GBFreq[20][28] = 582;
        DetectEncoding.GBFreq[42][20] = 581;
        DetectEncoding.GBFreq[34][38] = 580;
        DetectEncoding.GBFreq[45][9] = 579;
        DetectEncoding.GBFreq[54][50] = 578;
        DetectEncoding.GBFreq[25][44] = 577;
        DetectEncoding.GBFreq[35][66] = 576;
        DetectEncoding.GBFreq[20][55] = 575;
        DetectEncoding.GBFreq[18][85] = 574;
        DetectEncoding.GBFreq[20][31] = 573;
        DetectEncoding.GBFreq[49][17] = 572;
        DetectEncoding.GBFreq[41][16] = 571;
        DetectEncoding.GBFreq[35][73] = 570;
        DetectEncoding.GBFreq[20][34] = 569;
        DetectEncoding.GBFreq[29][44] = 568;
        DetectEncoding.GBFreq[35][38] = 567;
        DetectEncoding.GBFreq[49][9] = 566;
        DetectEncoding.GBFreq[46][33] = 565;
        DetectEncoding.GBFreq[49][51] = 564;
        DetectEncoding.GBFreq[40][89] = 563;
        DetectEncoding.GBFreq[26][64] = 562;
        DetectEncoding.GBFreq[54][51] = 561;
        DetectEncoding.GBFreq[54][36] = 560;
        DetectEncoding.GBFreq[39][4] = 559;
        DetectEncoding.GBFreq[53][13] = 558;
        DetectEncoding.GBFreq[24][92] = 557;
        DetectEncoding.GBFreq[27][49] = 556;
        DetectEncoding.GBFreq[48][6] = 555;
        DetectEncoding.GBFreq[21][51] = 554;
        DetectEncoding.GBFreq[30][40] = 553;
        DetectEncoding.GBFreq[42][92] = 552;
        DetectEncoding.GBFreq[31][78] = 551;
        DetectEncoding.GBFreq[25][82] = 550;
        DetectEncoding.GBFreq[47][0] = 549;
        DetectEncoding.GBFreq[34][19] = 548;
        DetectEncoding.GBFreq[47][35] = 547;
        DetectEncoding.GBFreq[21][63] = 546;
        DetectEncoding.GBFreq[43][75] = 545;
        DetectEncoding.GBFreq[21][87] = 544;
        DetectEncoding.GBFreq[35][59] = 543;
        DetectEncoding.GBFreq[25][34] = 542;
        DetectEncoding.GBFreq[21][27] = 541;
        DetectEncoding.GBFreq[39][26] = 540;
        DetectEncoding.GBFreq[34][26] = 539;
        DetectEncoding.GBFreq[39][52] = 538;
        DetectEncoding.GBFreq[50][57] = 537;
        DetectEncoding.GBFreq[37][79] = 536;
        DetectEncoding.GBFreq[26][24] = 535;
        DetectEncoding.GBFreq[22][1] = 534;
        DetectEncoding.GBFreq[18][40] = 533;
        DetectEncoding.GBFreq[41][33] = 532;
        DetectEncoding.GBFreq[53][26] = 531;
        DetectEncoding.GBFreq[54][86] = 530;
        DetectEncoding.GBFreq[20][16] = 529;
        DetectEncoding.GBFreq[46][74] = 528;
        DetectEncoding.GBFreq[30][19] = 527;
        DetectEncoding.GBFreq[45][35] = 526;
        DetectEncoding.GBFreq[45][61] = 525;
        DetectEncoding.GBFreq[30][9] = 524;
        DetectEncoding.GBFreq[41][53] = 523;
        DetectEncoding.GBFreq[41][13] = 522;
        DetectEncoding.GBFreq[50][34] = 521;
        DetectEncoding.GBFreq[53][86] = 520;
        DetectEncoding.GBFreq[47][47] = 519;
        DetectEncoding.GBFreq[22][28] = 518;
        DetectEncoding.GBFreq[50][53] = 517;
        DetectEncoding.GBFreq[39][70] = 516;
        DetectEncoding.GBFreq[38][15] = 515;
        DetectEncoding.GBFreq[42][88] = 514;
        DetectEncoding.GBFreq[16][29] = 513;
        DetectEncoding.GBFreq[27][90] = 512;
        DetectEncoding.GBFreq[29][12] = 511;
        DetectEncoding.GBFreq[44][22] = 510;
        DetectEncoding.GBFreq[34][69] = 509;
        DetectEncoding.GBFreq[24][10] = 508;
        DetectEncoding.GBFreq[44][11] = 507;
        DetectEncoding.GBFreq[39][92] = 506;
        DetectEncoding.GBFreq[49][48] = 505;
        DetectEncoding.GBFreq[31][46] = 504;
        DetectEncoding.GBFreq[19][50] = 503;
        DetectEncoding.GBFreq[21][14] = 502;
        DetectEncoding.GBFreq[32][28] = 501;
        DetectEncoding.GBFreq[18][3] = 500;
        DetectEncoding.GBFreq[53][9] = 499;
        DetectEncoding.GBFreq[34][80] = 498;
        DetectEncoding.GBFreq[48][88] = 497;
        DetectEncoding.GBFreq[46][53] = 496;
        DetectEncoding.GBFreq[22][53] = 495;
        DetectEncoding.GBFreq[28][10] = 494;
        DetectEncoding.GBFreq[44][65] = 493;
        DetectEncoding.GBFreq[20][10] = 492;
        DetectEncoding.GBFreq[40][76] = 491;
        DetectEncoding.GBFreq[47][8] = 490;
        DetectEncoding.GBFreq[50][74] = 489;
        DetectEncoding.GBFreq[23][62] = 488;
        DetectEncoding.GBFreq[49][65] = 487;
        DetectEncoding.GBFreq[28][87] = 486;
        DetectEncoding.GBFreq[15][48] = 485;
        DetectEncoding.GBFreq[22][7] = 484;
        DetectEncoding.GBFreq[19][42] = 483;
        DetectEncoding.GBFreq[41][20] = 482;
        DetectEncoding.GBFreq[26][55] = 481;
        DetectEncoding.GBFreq[21][93] = 480;
        DetectEncoding.GBFreq[31][76] = 479;
        DetectEncoding.GBFreq[34][31] = 478;
        DetectEncoding.GBFreq[20][66] = 477;
        DetectEncoding.GBFreq[51][33] = 476;
        DetectEncoding.GBFreq[34][86] = 475;
        DetectEncoding.GBFreq[37][67] = 474;
        DetectEncoding.GBFreq[53][53] = 473;
        DetectEncoding.GBFreq[40][88] = 472;
        DetectEncoding.GBFreq[39][10] = 471;
        DetectEncoding.GBFreq[24][3] = 470;
        DetectEncoding.GBFreq[27][25] = 469;
        DetectEncoding.GBFreq[26][15] = 468;
        DetectEncoding.GBFreq[21][88] = 467;
        DetectEncoding.GBFreq[52][62] = 466;
        DetectEncoding.GBFreq[46][81] = 465;
        DetectEncoding.GBFreq[38][72] = 464;
        DetectEncoding.GBFreq[17][30] = 463;
        DetectEncoding.GBFreq[52][92] = 462;
        DetectEncoding.GBFreq[34][90] = 461;
        DetectEncoding.GBFreq[21][7] = 460;
        DetectEncoding.GBFreq[36][13] = 459;
        DetectEncoding.GBFreq[45][41] = 458;
        DetectEncoding.GBFreq[32][5] = 457;
        DetectEncoding.GBFreq[26][89] = 456;
        DetectEncoding.GBFreq[23][87] = 455;
        DetectEncoding.GBFreq[20][39] = 454;
        DetectEncoding.GBFreq[27][23] = 453;
        DetectEncoding.GBFreq[25][59] = 452;
        DetectEncoding.GBFreq[49][20] = 451;
        DetectEncoding.GBFreq[54][77] = 450;
        DetectEncoding.GBFreq[27][67] = 449;
        DetectEncoding.GBFreq[47][33] = 448;
        DetectEncoding.GBFreq[41][17] = 447;
        DetectEncoding.GBFreq[19][81] = 446;
        DetectEncoding.GBFreq[16][66] = 445;
        DetectEncoding.GBFreq[45][26] = 444;
        DetectEncoding.GBFreq[49][81] = 443;
        DetectEncoding.GBFreq[53][55] = 442;
        DetectEncoding.GBFreq[16][26] = 441;
        DetectEncoding.GBFreq[54][62] = 440;
        DetectEncoding.GBFreq[20][70] = 439;
        DetectEncoding.GBFreq[42][35] = 438;
        DetectEncoding.GBFreq[20][57] = 437;
        DetectEncoding.GBFreq[34][36] = 436;
        DetectEncoding.GBFreq[46][63] = 435;
        DetectEncoding.GBFreq[19][45] = 434;
        DetectEncoding.GBFreq[21][10] = 433;
        DetectEncoding.GBFreq[52][93] = 432;
        DetectEncoding.GBFreq[25][2] = 431;
        DetectEncoding.GBFreq[30][57] = 430;
        DetectEncoding.GBFreq[41][24] = 429;
        DetectEncoding.GBFreq[28][43] = 428;
        DetectEncoding.GBFreq[45][86] = 427;
        DetectEncoding.GBFreq[51][56] = 426;
        DetectEncoding.GBFreq[37][28] = 425;
        DetectEncoding.GBFreq[52][69] = 424;
        DetectEncoding.GBFreq[43][92] = 423;
        DetectEncoding.GBFreq[41][31] = 422;
        DetectEncoding.GBFreq[37][87] = 421;
        DetectEncoding.GBFreq[47][36] = 420;
        DetectEncoding.GBFreq[16][16] = 419;
        DetectEncoding.GBFreq[40][56] = 418;
        DetectEncoding.GBFreq[24][55] = 417;
        DetectEncoding.GBFreq[17][1] = 416;
        DetectEncoding.GBFreq[35][57] = 415;
        DetectEncoding.GBFreq[27][50] = 414;
        DetectEncoding.GBFreq[26][14] = 413;
        DetectEncoding.GBFreq[50][40] = 412;
        DetectEncoding.GBFreq[39][19] = 411;
        DetectEncoding.GBFreq[19][89] = 410;
        DetectEncoding.GBFreq[29][91] = 409;
        DetectEncoding.GBFreq[17][89] = 408;
        DetectEncoding.GBFreq[39][74] = 407;
        DetectEncoding.GBFreq[46][39] = 406;
        DetectEncoding.GBFreq[40][28] = 405;
        DetectEncoding.GBFreq[45][68] = 404;
        DetectEncoding.GBFreq[43][10] = 403;
        DetectEncoding.GBFreq[42][13] = 402;
        DetectEncoding.GBFreq[44][81] = 401;
        DetectEncoding.GBFreq[41][47] = 400;
        DetectEncoding.GBFreq[48][58] = 399;
        DetectEncoding.GBFreq[43][68] = 398;
        DetectEncoding.GBFreq[16][79] = 397;
        DetectEncoding.GBFreq[19][5] = 396;
        DetectEncoding.GBFreq[54][59] = 395;
        DetectEncoding.GBFreq[17][36] = 394;
        DetectEncoding.GBFreq[18][0] = 393;
        DetectEncoding.GBFreq[41][5] = 392;
        DetectEncoding.GBFreq[41][72] = 391;
        DetectEncoding.GBFreq[16][39] = 390;
        DetectEncoding.GBFreq[54][0] = 389;
        DetectEncoding.GBFreq[51][16] = 388;
        DetectEncoding.GBFreq[29][36] = 387;
        DetectEncoding.GBFreq[47][5] = 386;
        DetectEncoding.GBFreq[47][51] = 385;
        DetectEncoding.GBFreq[44][7] = 384;
        DetectEncoding.GBFreq[35][30] = 383;
        DetectEncoding.GBFreq[26][9] = 382;
        DetectEncoding.GBFreq[16][7] = 381;
        DetectEncoding.GBFreq[32][1] = 380;
        DetectEncoding.GBFreq[33][76] = 379;
        DetectEncoding.GBFreq[34][91] = 378;
        DetectEncoding.GBFreq[52][36] = 377;
        DetectEncoding.GBFreq[26][77] = 376;
        DetectEncoding.GBFreq[35][48] = 375;
        DetectEncoding.GBFreq[40][80] = 374;
        DetectEncoding.GBFreq[41][92] = 373;
        DetectEncoding.GBFreq[27][93] = 372;
        DetectEncoding.GBFreq[15][17] = 371;
        DetectEncoding.GBFreq[16][76] = 370;
        DetectEncoding.GBFreq[51][12] = 369;
        DetectEncoding.GBFreq[18][20] = 368;
        DetectEncoding.GBFreq[15][54] = 367;
        DetectEncoding.GBFreq[50][5] = 366;
        DetectEncoding.GBFreq[33][22] = 365;
        DetectEncoding.GBFreq[37][57] = 364;
        DetectEncoding.GBFreq[28][47] = 363;
        DetectEncoding.GBFreq[42][31] = 362;
        DetectEncoding.GBFreq[18][2] = 361;
        DetectEncoding.GBFreq[43][64] = 360;
        DetectEncoding.GBFreq[23][47] = 359;
        DetectEncoding.GBFreq[28][79] = 358;
        DetectEncoding.GBFreq[25][45] = 357;
        DetectEncoding.GBFreq[23][91] = 356;
        DetectEncoding.GBFreq[22][19] = 355;
        DetectEncoding.GBFreq[25][46] = 354;
        DetectEncoding.GBFreq[22][36] = 353;
        DetectEncoding.GBFreq[54][85] = 352;
        DetectEncoding.GBFreq[46][20] = 351;
        DetectEncoding.GBFreq[27][37] = 350;
        DetectEncoding.GBFreq[26][81] = 349;
        DetectEncoding.GBFreq[42][29] = 348;
        DetectEncoding.GBFreq[31][90] = 347;
        DetectEncoding.GBFreq[41][59] = 346;
        DetectEncoding.GBFreq[24][65] = 345;
        DetectEncoding.GBFreq[44][84] = 344;
        DetectEncoding.GBFreq[24][90] = 343;
        DetectEncoding.GBFreq[38][54] = 342;
        DetectEncoding.GBFreq[28][70] = 341;
        DetectEncoding.GBFreq[27][15] = 340;
        DetectEncoding.GBFreq[28][80] = 339;
        DetectEncoding.GBFreq[29][8] = 338;
        DetectEncoding.GBFreq[45][80] = 337;
        DetectEncoding.GBFreq[53][37] = 336;
        DetectEncoding.GBFreq[28][65] = 335;
        DetectEncoding.GBFreq[23][86] = 334;
        DetectEncoding.GBFreq[39][45] = 333;
        DetectEncoding.GBFreq[53][32] = 332;
        DetectEncoding.GBFreq[38][68] = 331;
        DetectEncoding.GBFreq[45][78] = 330;
        DetectEncoding.GBFreq[43][7] = 329;
        DetectEncoding.GBFreq[46][82] = 328;
        DetectEncoding.GBFreq[27][38] = 327;
        DetectEncoding.GBFreq[16][62] = 326;
        DetectEncoding.GBFreq[24][17] = 325;
        DetectEncoding.GBFreq[22][70] = 324;
        DetectEncoding.GBFreq[52][28] = 323;
        DetectEncoding.GBFreq[23][40] = 322;
        DetectEncoding.GBFreq[28][50] = 321;
        DetectEncoding.GBFreq[42][91] = 320;
        DetectEncoding.GBFreq[47][76] = 319;
        DetectEncoding.GBFreq[15][42] = 318;
        DetectEncoding.GBFreq[43][55] = 317;
        DetectEncoding.GBFreq[29][84] = 316;
        DetectEncoding.GBFreq[44][90] = 315;
        DetectEncoding.GBFreq[53][16] = 314;
        DetectEncoding.GBFreq[22][93] = 313;
        DetectEncoding.GBFreq[34][10] = 312;
        DetectEncoding.GBFreq[32][53] = 311;
        DetectEncoding.GBFreq[43][65] = 310;
        DetectEncoding.GBFreq[28][7] = 309;
        DetectEncoding.GBFreq[35][46] = 308;
        DetectEncoding.GBFreq[21][39] = 307;
        DetectEncoding.GBFreq[44][18] = 306;
        DetectEncoding.GBFreq[40][10] = 305;
        DetectEncoding.GBFreq[54][53] = 304;
        DetectEncoding.GBFreq[38][74] = 303;
        DetectEncoding.GBFreq[28][26] = 302;
        DetectEncoding.GBFreq[15][13] = 301;
        DetectEncoding.GBFreq[39][34] = 300;
        DetectEncoding.GBFreq[39][46] = 299;
        DetectEncoding.GBFreq[42][66] = 298;
        DetectEncoding.GBFreq[33][58] = 297;
        DetectEncoding.GBFreq[15][56] = 296;
        DetectEncoding.GBFreq[18][51] = 295;
        DetectEncoding.GBFreq[49][68] = 294;
        DetectEncoding.GBFreq[30][37] = 293;
        DetectEncoding.GBFreq[51][84] = 292;
        DetectEncoding.GBFreq[51][9] = 291;
        DetectEncoding.GBFreq[40][70] = 290;
        DetectEncoding.GBFreq[41][84] = 289;
        DetectEncoding.GBFreq[28][64] = 288;
        DetectEncoding.GBFreq[32][88] = 287;
        DetectEncoding.GBFreq[24][5] = 286;
        DetectEncoding.GBFreq[53][23] = 285;
        DetectEncoding.GBFreq[42][27] = 284;
        DetectEncoding.GBFreq[22][38] = 283;
        DetectEncoding.GBFreq[32][86] = 282;
        DetectEncoding.GBFreq[34][30] = 281;
        DetectEncoding.GBFreq[38][63] = 280;
        DetectEncoding.GBFreq[24][59] = 279;
        DetectEncoding.GBFreq[22][81] = 278;
        DetectEncoding.GBFreq[32][11] = 277;
        DetectEncoding.GBFreq[51][21] = 276;
        DetectEncoding.GBFreq[54][41] = 275;
        DetectEncoding.GBFreq[21][50] = 274;
        DetectEncoding.GBFreq[23][89] = 273;
        DetectEncoding.GBFreq[19][87] = 272;
        DetectEncoding.GBFreq[26][7] = 271;
        DetectEncoding.GBFreq[30][75] = 270;
        DetectEncoding.GBFreq[43][84] = 269;
        DetectEncoding.GBFreq[51][25] = 268;
        DetectEncoding.GBFreq[16][67] = 267;
        DetectEncoding.GBFreq[32][9] = 266;
        DetectEncoding.GBFreq[48][51] = 265;
        DetectEncoding.GBFreq[39][7] = 264;
        DetectEncoding.GBFreq[44][88] = 263;
        DetectEncoding.GBFreq[52][24] = 262;
        DetectEncoding.GBFreq[23][34] = 261;
        DetectEncoding.GBFreq[32][75] = 260;
        DetectEncoding.GBFreq[19][10] = 259;
        DetectEncoding.GBFreq[28][91] = 258;
        DetectEncoding.GBFreq[32][83] = 257;
        DetectEncoding.GBFreq[25][75] = 256;
        DetectEncoding.GBFreq[53][45] = 255;
        DetectEncoding.GBFreq[29][85] = 254;
        DetectEncoding.GBFreq[53][59] = 253;
        DetectEncoding.GBFreq[16][2] = 252;
        DetectEncoding.GBFreq[19][78] = 251;
        DetectEncoding.GBFreq[15][75] = 250;
        DetectEncoding.GBFreq[51][42] = 249;
        DetectEncoding.GBFreq[45][67] = 248;
        DetectEncoding.GBFreq[15][74] = 247;
        DetectEncoding.GBFreq[25][81] = 246;
        DetectEncoding.GBFreq[37][62] = 245;
        DetectEncoding.GBFreq[16][55] = 244;
        DetectEncoding.GBFreq[18][38] = 243;
        DetectEncoding.GBFreq[23][23] = 242;
        DetectEncoding.GBFreq[38][30] = 241;
        DetectEncoding.GBFreq[17][28] = 240;
        DetectEncoding.GBFreq[44][73] = 239;
        DetectEncoding.GBFreq[23][78] = 238;
        DetectEncoding.GBFreq[40][77] = 237;
        DetectEncoding.GBFreq[38][87] = 236;
        DetectEncoding.GBFreq[27][19] = 235;
        DetectEncoding.GBFreq[38][82] = 234;
        DetectEncoding.GBFreq[37][22] = 233;
        DetectEncoding.GBFreq[41][30] = 232;
        DetectEncoding.GBFreq[54][9] = 231;
        DetectEncoding.GBFreq[32][30] = 230;
        DetectEncoding.GBFreq[30][52] = 229;
        DetectEncoding.GBFreq[40][84] = 228;
        DetectEncoding.GBFreq[53][57] = 227;
        DetectEncoding.GBFreq[27][27] = 226;
        DetectEncoding.GBFreq[38][64] = 225;
        DetectEncoding.GBFreq[18][43] = 224;
        DetectEncoding.GBFreq[23][69] = 223;
        DetectEncoding.GBFreq[28][12] = 222;
        DetectEncoding.GBFreq[50][78] = 221;
        DetectEncoding.GBFreq[50][1] = 220;
        DetectEncoding.GBFreq[26][88] = 219;
        DetectEncoding.GBFreq[36][40] = 218;
        DetectEncoding.GBFreq[33][89] = 217;
        DetectEncoding.GBFreq[41][28] = 216;
        DetectEncoding.GBFreq[31][77] = 215;
        DetectEncoding.GBFreq[46][1] = 214;
        DetectEncoding.GBFreq[47][19] = 213;
        DetectEncoding.GBFreq[35][55] = 212;
        DetectEncoding.GBFreq[41][21] = 211;
        DetectEncoding.GBFreq[27][10] = 210;
        DetectEncoding.GBFreq[32][77] = 209;
        DetectEncoding.GBFreq[26][37] = 208;
        DetectEncoding.GBFreq[20][33] = 207;
        DetectEncoding.GBFreq[41][52] = 206;
        DetectEncoding.GBFreq[32][18] = 205;
        DetectEncoding.GBFreq[38][13] = 204;
        DetectEncoding.GBFreq[20][18] = 203;
        DetectEncoding.GBFreq[20][24] = 202;
        DetectEncoding.GBFreq[45][19] = 201;
        DetectEncoding.GBFreq[18][53] = 200;
        DetectEncoding.Big5Freq[9][89] = 600;
        DetectEncoding.Big5Freq[11][15] = 599;
        DetectEncoding.Big5Freq[3][66] = 598;
        DetectEncoding.Big5Freq[6][121] = 597;
        DetectEncoding.Big5Freq[3][0] = 596;
        DetectEncoding.Big5Freq[5][82] = 595;
        DetectEncoding.Big5Freq[3][42] = 594;
        DetectEncoding.Big5Freq[5][34] = 593;
        DetectEncoding.Big5Freq[3][8] = 592;
        DetectEncoding.Big5Freq[3][6] = 591;
        DetectEncoding.Big5Freq[3][67] = 590;
        DetectEncoding.Big5Freq[7][139] = 589;
        DetectEncoding.Big5Freq[23][137] = 588;
        DetectEncoding.Big5Freq[12][46] = 587;
        DetectEncoding.Big5Freq[4][8] = 586;
        DetectEncoding.Big5Freq[4][41] = 585;
        DetectEncoding.Big5Freq[18][47] = 584;
        DetectEncoding.Big5Freq[12][114] = 583;
        DetectEncoding.Big5Freq[6][1] = 582;
        DetectEncoding.Big5Freq[22][60] = 581;
        DetectEncoding.Big5Freq[5][46] = 580;
        DetectEncoding.Big5Freq[11][79] = 579;
        DetectEncoding.Big5Freq[3][23] = 578;
        DetectEncoding.Big5Freq[7][114] = 577;
        DetectEncoding.Big5Freq[29][102] = 576;
        DetectEncoding.Big5Freq[19][14] = 575;
        DetectEncoding.Big5Freq[4][133] = 574;
        DetectEncoding.Big5Freq[3][29] = 573;
        DetectEncoding.Big5Freq[4][109] = 572;
        DetectEncoding.Big5Freq[14][127] = 571;
        DetectEncoding.Big5Freq[5][48] = 570;
        DetectEncoding.Big5Freq[13][104] = 569;
        DetectEncoding.Big5Freq[3][132] = 568;
        DetectEncoding.Big5Freq[26][64] = 567;
        DetectEncoding.Big5Freq[7][19] = 566;
        DetectEncoding.Big5Freq[4][12] = 565;
        DetectEncoding.Big5Freq[11][124] = 564;
        DetectEncoding.Big5Freq[7][89] = 563;
        DetectEncoding.Big5Freq[15][124] = 562;
        DetectEncoding.Big5Freq[4][108] = 561;
        DetectEncoding.Big5Freq[19][66] = 560;
        DetectEncoding.Big5Freq[3][21] = 559;
        DetectEncoding.Big5Freq[24][12] = 558;
        DetectEncoding.Big5Freq[28][111] = 557;
        DetectEncoding.Big5Freq[12][107] = 556;
        DetectEncoding.Big5Freq[3][112] = 555;
        DetectEncoding.Big5Freq[8][113] = 554;
        DetectEncoding.Big5Freq[5][40] = 553;
        DetectEncoding.Big5Freq[26][145] = 552;
        DetectEncoding.Big5Freq[3][48] = 551;
        DetectEncoding.Big5Freq[3][70] = 550;
        DetectEncoding.Big5Freq[22][17] = 549;
        DetectEncoding.Big5Freq[16][47] = 548;
        DetectEncoding.Big5Freq[3][53] = 547;
        DetectEncoding.Big5Freq[4][24] = 546;
        DetectEncoding.Big5Freq[32][120] = 545;
        DetectEncoding.Big5Freq[24][49] = 544;
        DetectEncoding.Big5Freq[24][142] = 543;
        DetectEncoding.Big5Freq[18][66] = 542;
        DetectEncoding.Big5Freq[29][150] = 541;
        DetectEncoding.Big5Freq[5][122] = 540;
        DetectEncoding.Big5Freq[5][114] = 539;
        DetectEncoding.Big5Freq[3][44] = 538;
        DetectEncoding.Big5Freq[10][128] = 537;
        DetectEncoding.Big5Freq[15][20] = 536;
        DetectEncoding.Big5Freq[13][33] = 535;
        DetectEncoding.Big5Freq[14][87] = 534;
        DetectEncoding.Big5Freq[3][126] = 533;
        DetectEncoding.Big5Freq[4][53] = 532;
        DetectEncoding.Big5Freq[4][40] = 531;
        DetectEncoding.Big5Freq[9][93] = 530;
        DetectEncoding.Big5Freq[15][137] = 529;
        DetectEncoding.Big5Freq[10][123] = 528;
        DetectEncoding.Big5Freq[4][56] = 527;
        DetectEncoding.Big5Freq[5][71] = 526;
        DetectEncoding.Big5Freq[10][8] = 525;
        DetectEncoding.Big5Freq[5][16] = 524;
        DetectEncoding.Big5Freq[5][146] = 523;
        DetectEncoding.Big5Freq[18][88] = 522;
        DetectEncoding.Big5Freq[24][4] = 521;
        DetectEncoding.Big5Freq[20][47] = 520;
        DetectEncoding.Big5Freq[5][33] = 519;
        DetectEncoding.Big5Freq[9][43] = 518;
        DetectEncoding.Big5Freq[20][12] = 517;
        DetectEncoding.Big5Freq[20][13] = 516;
        DetectEncoding.Big5Freq[5][156] = 515;
        DetectEncoding.Big5Freq[22][140] = 514;
        DetectEncoding.Big5Freq[8][146] = 513;
        DetectEncoding.Big5Freq[21][123] = 512;
        DetectEncoding.Big5Freq[4][90] = 511;
        DetectEncoding.Big5Freq[5][62] = 510;
        DetectEncoding.Big5Freq[17][59] = 509;
        DetectEncoding.Big5Freq[10][37] = 508;
        DetectEncoding.Big5Freq[18][107] = 507;
        DetectEncoding.Big5Freq[14][53] = 506;
        DetectEncoding.Big5Freq[22][51] = 505;
        DetectEncoding.Big5Freq[8][13] = 504;
        DetectEncoding.Big5Freq[5][29] = 503;
        DetectEncoding.Big5Freq[9][7] = 502;
        DetectEncoding.Big5Freq[22][14] = 501;
        DetectEncoding.Big5Freq[8][55] = 500;
        DetectEncoding.Big5Freq[33][9] = 499;
        DetectEncoding.Big5Freq[16][64] = 498;
        DetectEncoding.Big5Freq[7][131] = 497;
        DetectEncoding.Big5Freq[34][4] = 496;
        DetectEncoding.Big5Freq[7][101] = 495;
        DetectEncoding.Big5Freq[11][139] = 494;
        DetectEncoding.Big5Freq[3][135] = 493;
        DetectEncoding.Big5Freq[7][102] = 492;
        DetectEncoding.Big5Freq[17][13] = 491;
        DetectEncoding.Big5Freq[3][20] = 490;
        DetectEncoding.Big5Freq[27][106] = 489;
        DetectEncoding.Big5Freq[5][88] = 488;
        DetectEncoding.Big5Freq[6][33] = 487;
        DetectEncoding.Big5Freq[5][139] = 486;
        DetectEncoding.Big5Freq[6][0] = 485;
        DetectEncoding.Big5Freq[17][58] = 484;
        DetectEncoding.Big5Freq[5][133] = 483;
        DetectEncoding.Big5Freq[9][107] = 482;
        DetectEncoding.Big5Freq[23][39] = 481;
        DetectEncoding.Big5Freq[5][23] = 480;
        DetectEncoding.Big5Freq[3][79] = 479;
        DetectEncoding.Big5Freq[32][97] = 478;
        DetectEncoding.Big5Freq[3][136] = 477;
        DetectEncoding.Big5Freq[4][94] = 476;
        DetectEncoding.Big5Freq[21][61] = 475;
        DetectEncoding.Big5Freq[23][123] = 474;
        DetectEncoding.Big5Freq[26][16] = 473;
        DetectEncoding.Big5Freq[24][137] = 472;
        DetectEncoding.Big5Freq[22][18] = 471;
        DetectEncoding.Big5Freq[5][1] = 470;
        DetectEncoding.Big5Freq[20][119] = 469;
        DetectEncoding.Big5Freq[3][7] = 468;
        DetectEncoding.Big5Freq[10][79] = 467;
        DetectEncoding.Big5Freq[15][105] = 466;
        DetectEncoding.Big5Freq[3][144] = 465;
        DetectEncoding.Big5Freq[12][80] = 464;
        DetectEncoding.Big5Freq[15][73] = 463;
        DetectEncoding.Big5Freq[3][19] = 462;
        DetectEncoding.Big5Freq[8][109] = 461;
        DetectEncoding.Big5Freq[3][15] = 460;
        DetectEncoding.Big5Freq[31][82] = 459;
        DetectEncoding.Big5Freq[3][43] = 458;
        DetectEncoding.Big5Freq[25][119] = 457;
        DetectEncoding.Big5Freq[16][111] = 456;
        DetectEncoding.Big5Freq[7][77] = 455;
        DetectEncoding.Big5Freq[3][95] = 454;
        DetectEncoding.Big5Freq[24][82] = 453;
        DetectEncoding.Big5Freq[7][52] = 452;
        DetectEncoding.Big5Freq[9][151] = 451;
        DetectEncoding.Big5Freq[3][129] = 450;
        DetectEncoding.Big5Freq[5][87] = 449;
        DetectEncoding.Big5Freq[3][55] = 448;
        DetectEncoding.Big5Freq[8][153] = 447;
        DetectEncoding.Big5Freq[4][83] = 446;
        DetectEncoding.Big5Freq[3][114] = 445;
        DetectEncoding.Big5Freq[23][147] = 444;
        DetectEncoding.Big5Freq[15][31] = 443;
        DetectEncoding.Big5Freq[3][54] = 442;
        DetectEncoding.Big5Freq[11][122] = 441;
        DetectEncoding.Big5Freq[4][4] = 440;
        DetectEncoding.Big5Freq[34][149] = 439;
        DetectEncoding.Big5Freq[3][17] = 438;
        DetectEncoding.Big5Freq[21][64] = 437;
        DetectEncoding.Big5Freq[26][144] = 436;
        DetectEncoding.Big5Freq[4][62] = 435;
        DetectEncoding.Big5Freq[8][15] = 434;
        DetectEncoding.Big5Freq[35][80] = 433;
        DetectEncoding.Big5Freq[7][110] = 432;
        DetectEncoding.Big5Freq[23][114] = 431;
        DetectEncoding.Big5Freq[3][108] = 430;
        DetectEncoding.Big5Freq[3][62] = 429;
        DetectEncoding.Big5Freq[21][41] = 428;
        DetectEncoding.Big5Freq[15][99] = 427;
        DetectEncoding.Big5Freq[5][47] = 426;
        DetectEncoding.Big5Freq[4][96] = 425;
        DetectEncoding.Big5Freq[20][122] = 424;
        DetectEncoding.Big5Freq[5][21] = 423;
        DetectEncoding.Big5Freq[4][157] = 422;
        DetectEncoding.Big5Freq[16][14] = 421;
        DetectEncoding.Big5Freq[3][117] = 420;
        DetectEncoding.Big5Freq[7][129] = 419;
        DetectEncoding.Big5Freq[4][27] = 418;
        DetectEncoding.Big5Freq[5][30] = 417;
        DetectEncoding.Big5Freq[22][16] = 416;
        DetectEncoding.Big5Freq[5][64] = 415;
        DetectEncoding.Big5Freq[17][99] = 414;
        DetectEncoding.Big5Freq[17][57] = 413;
        DetectEncoding.Big5Freq[8][105] = 412;
        DetectEncoding.Big5Freq[5][112] = 411;
        DetectEncoding.Big5Freq[20][59] = 410;
        DetectEncoding.Big5Freq[6][129] = 409;
        DetectEncoding.Big5Freq[18][17] = 408;
        DetectEncoding.Big5Freq[3][92] = 407;
        DetectEncoding.Big5Freq[28][118] = 406;
        DetectEncoding.Big5Freq[3][109] = 405;
        DetectEncoding.Big5Freq[31][51] = 404;
        DetectEncoding.Big5Freq[13][116] = 403;
        DetectEncoding.Big5Freq[6][15] = 402;
        DetectEncoding.Big5Freq[36][136] = 401;
        DetectEncoding.Big5Freq[12][74] = 400;
        DetectEncoding.Big5Freq[20][88] = 399;
        DetectEncoding.Big5Freq[36][68] = 398;
        DetectEncoding.Big5Freq[3][147] = 397;
        DetectEncoding.Big5Freq[15][84] = 396;
        DetectEncoding.Big5Freq[16][32] = 395;
        DetectEncoding.Big5Freq[16][58] = 394;
        DetectEncoding.Big5Freq[7][66] = 393;
        DetectEncoding.Big5Freq[23][107] = 392;
        DetectEncoding.Big5Freq[9][6] = 391;
        DetectEncoding.Big5Freq[12][86] = 390;
        DetectEncoding.Big5Freq[23][112] = 389;
        DetectEncoding.Big5Freq[37][23] = 388;
        DetectEncoding.Big5Freq[3][138] = 387;
        DetectEncoding.Big5Freq[20][68] = 386;
        DetectEncoding.Big5Freq[15][116] = 385;
        DetectEncoding.Big5Freq[18][64] = 384;
        DetectEncoding.Big5Freq[12][139] = 383;
        DetectEncoding.Big5Freq[11][155] = 382;
        DetectEncoding.Big5Freq[4][156] = 381;
        DetectEncoding.Big5Freq[12][84] = 380;
        DetectEncoding.Big5Freq[18][49] = 379;
        DetectEncoding.Big5Freq[25][125] = 378;
        DetectEncoding.Big5Freq[25][147] = 377;
        DetectEncoding.Big5Freq[15][110] = 376;
        DetectEncoding.Big5Freq[19][96] = 375;
        DetectEncoding.Big5Freq[30][152] = 374;
        DetectEncoding.Big5Freq[6][31] = 373;
        DetectEncoding.Big5Freq[27][117] = 372;
        DetectEncoding.Big5Freq[3][10] = 371;
        DetectEncoding.Big5Freq[6][131] = 370;
        DetectEncoding.Big5Freq[13][112] = 369;
        DetectEncoding.Big5Freq[36][156] = 368;
        DetectEncoding.Big5Freq[4][60] = 367;
        DetectEncoding.Big5Freq[15][121] = 366;
        DetectEncoding.Big5Freq[4][112] = 365;
        DetectEncoding.Big5Freq[30][142] = 364;
        DetectEncoding.Big5Freq[23][154] = 363;
        DetectEncoding.Big5Freq[27][101] = 362;
        DetectEncoding.Big5Freq[9][140] = 361;
        DetectEncoding.Big5Freq[3][89] = 360;
        DetectEncoding.Big5Freq[18][148] = 359;
        DetectEncoding.Big5Freq[4][69] = 358;
        DetectEncoding.Big5Freq[16][49] = 357;
        DetectEncoding.Big5Freq[6][117] = 356;
        DetectEncoding.Big5Freq[36][55] = 355;
        DetectEncoding.Big5Freq[5][123] = 354;
        DetectEncoding.Big5Freq[4][126] = 353;
        DetectEncoding.Big5Freq[4][119] = 352;
        DetectEncoding.Big5Freq[9][95] = 351;
        DetectEncoding.Big5Freq[5][24] = 350;
        DetectEncoding.Big5Freq[16][133] = 349;
        DetectEncoding.Big5Freq[10][134] = 348;
        DetectEncoding.Big5Freq[26][59] = 347;
        DetectEncoding.Big5Freq[6][41] = 346;
        DetectEncoding.Big5Freq[6][146] = 345;
        DetectEncoding.Big5Freq[19][24] = 344;
        DetectEncoding.Big5Freq[5][113] = 343;
        DetectEncoding.Big5Freq[10][118] = 342;
        DetectEncoding.Big5Freq[34][151] = 341;
        DetectEncoding.Big5Freq[9][72] = 340;
        DetectEncoding.Big5Freq[31][25] = 339;
        DetectEncoding.Big5Freq[18][126] = 338;
        DetectEncoding.Big5Freq[18][28] = 337;
        DetectEncoding.Big5Freq[4][153] = 336;
        DetectEncoding.Big5Freq[3][84] = 335;
        DetectEncoding.Big5Freq[21][18] = 334;
        DetectEncoding.Big5Freq[25][129] = 333;
        DetectEncoding.Big5Freq[6][107] = 332;
        DetectEncoding.Big5Freq[12][25] = 331;
        DetectEncoding.Big5Freq[17][109] = 330;
        DetectEncoding.Big5Freq[7][76] = 329;
        DetectEncoding.Big5Freq[15][15] = 328;
        DetectEncoding.Big5Freq[4][14] = 327;
        DetectEncoding.Big5Freq[23][88] = 326;
        DetectEncoding.Big5Freq[18][2] = 325;
        DetectEncoding.Big5Freq[6][88] = 324;
        DetectEncoding.Big5Freq[16][84] = 323;
        DetectEncoding.Big5Freq[12][48] = 322;
        DetectEncoding.Big5Freq[7][68] = 321;
        DetectEncoding.Big5Freq[5][50] = 320;
        DetectEncoding.Big5Freq[13][54] = 319;
        DetectEncoding.Big5Freq[7][98] = 318;
        DetectEncoding.Big5Freq[11][6] = 317;
        DetectEncoding.Big5Freq[9][80] = 316;
        DetectEncoding.Big5Freq[16][41] = 315;
        DetectEncoding.Big5Freq[7][43] = 314;
        DetectEncoding.Big5Freq[28][117] = 313;
        DetectEncoding.Big5Freq[3][51] = 312;
        DetectEncoding.Big5Freq[7][3] = 311;
        DetectEncoding.Big5Freq[20][81] = 310;
        DetectEncoding.Big5Freq[4][2] = 309;
        DetectEncoding.Big5Freq[11][16] = 308;
        DetectEncoding.Big5Freq[10][4] = 307;
        DetectEncoding.Big5Freq[10][119] = 306;
        DetectEncoding.Big5Freq[6][142] = 305;
        DetectEncoding.Big5Freq[18][51] = 304;
        DetectEncoding.Big5Freq[8][144] = 303;
        DetectEncoding.Big5Freq[10][65] = 302;
        DetectEncoding.Big5Freq[11][64] = 301;
        DetectEncoding.Big5Freq[11][130] = 300;
        DetectEncoding.Big5Freq[9][92] = 299;
        DetectEncoding.Big5Freq[18][29] = 298;
        DetectEncoding.Big5Freq[18][78] = 297;
        DetectEncoding.Big5Freq[18][151] = 296;
        DetectEncoding.Big5Freq[33][127] = 295;
        DetectEncoding.Big5Freq[35][113] = 294;
        DetectEncoding.Big5Freq[10][155] = 293;
        DetectEncoding.Big5Freq[3][76] = 292;
        DetectEncoding.Big5Freq[36][123] = 291;
        DetectEncoding.Big5Freq[13][143] = 290;
        DetectEncoding.Big5Freq[5][135] = 289;
        DetectEncoding.Big5Freq[23][116] = 288;
        DetectEncoding.Big5Freq[6][101] = 287;
        DetectEncoding.Big5Freq[14][74] = 286;
        DetectEncoding.Big5Freq[7][153] = 285;
        DetectEncoding.Big5Freq[3][101] = 284;
        DetectEncoding.Big5Freq[9][74] = 283;
        DetectEncoding.Big5Freq[3][156] = 282;
        DetectEncoding.Big5Freq[4][147] = 281;
        DetectEncoding.Big5Freq[9][12] = 280;
        DetectEncoding.Big5Freq[18][133] = 279;
        DetectEncoding.Big5Freq[4][0] = 278;
        DetectEncoding.Big5Freq[7][155] = 277;
        DetectEncoding.Big5Freq[9][144] = 276;
        DetectEncoding.Big5Freq[23][49] = 275;
        DetectEncoding.Big5Freq[5][89] = 274;
        DetectEncoding.Big5Freq[10][11] = 273;
        DetectEncoding.Big5Freq[3][110] = 272;
        DetectEncoding.Big5Freq[3][40] = 271;
        DetectEncoding.Big5Freq[29][115] = 270;
        DetectEncoding.Big5Freq[9][100] = 269;
        DetectEncoding.Big5Freq[21][67] = 268;
        DetectEncoding.Big5Freq[23][145] = 267;
        DetectEncoding.Big5Freq[10][47] = 266;
        DetectEncoding.Big5Freq[4][31] = 265;
        DetectEncoding.Big5Freq[4][81] = 264;
        DetectEncoding.Big5Freq[22][62] = 263;
        DetectEncoding.Big5Freq[4][28] = 262;
        DetectEncoding.Big5Freq[27][39] = 261;
        DetectEncoding.Big5Freq[27][54] = 260;
        DetectEncoding.Big5Freq[32][46] = 259;
        DetectEncoding.Big5Freq[4][76] = 258;
        DetectEncoding.Big5Freq[26][15] = 257;
        DetectEncoding.Big5Freq[12][154] = 256;
        DetectEncoding.Big5Freq[9][150] = 255;
        DetectEncoding.Big5Freq[15][17] = 254;
        DetectEncoding.Big5Freq[5][129] = 253;
        DetectEncoding.Big5Freq[10][40] = 252;
        DetectEncoding.Big5Freq[13][37] = 251;
        DetectEncoding.Big5Freq[31][104] = 250;
        DetectEncoding.Big5Freq[3][152] = 249;
        DetectEncoding.Big5Freq[5][22] = 248;
        DetectEncoding.Big5Freq[8][48] = 247;
        DetectEncoding.Big5Freq[4][74] = 246;
        DetectEncoding.Big5Freq[6][17] = 245;
        DetectEncoding.Big5Freq[30][82] = 244;
        DetectEncoding.Big5Freq[4][116] = 243;
        DetectEncoding.Big5Freq[16][42] = 242;
        DetectEncoding.Big5Freq[5][55] = 241;
        DetectEncoding.Big5Freq[4][64] = 240;
        DetectEncoding.Big5Freq[14][19] = 239;
        DetectEncoding.Big5Freq[35][82] = 238;
        DetectEncoding.Big5Freq[30][139] = 237;
        DetectEncoding.Big5Freq[26][152] = 236;
        DetectEncoding.Big5Freq[32][32] = 235;
        DetectEncoding.Big5Freq[21][102] = 234;
        DetectEncoding.Big5Freq[10][131] = 233;
        DetectEncoding.Big5Freq[9][128] = 232;
        DetectEncoding.Big5Freq[3][87] = 231;
        DetectEncoding.Big5Freq[4][51] = 230;
        DetectEncoding.Big5Freq[10][15] = 229;
        DetectEncoding.Big5Freq[4][150] = 228;
        DetectEncoding.Big5Freq[7][4] = 227;
        DetectEncoding.Big5Freq[7][51] = 226;
        DetectEncoding.Big5Freq[7][157] = 225;
        DetectEncoding.Big5Freq[4][146] = 224;
        DetectEncoding.Big5Freq[4][91] = 223;
        DetectEncoding.Big5Freq[7][13] = 222;
        DetectEncoding.Big5Freq[17][116] = 221;
        DetectEncoding.Big5Freq[23][21] = 220;
        DetectEncoding.Big5Freq[5][106] = 219;
        DetectEncoding.Big5Freq[14][100] = 218;
        DetectEncoding.Big5Freq[10][152] = 217;
        DetectEncoding.Big5Freq[14][89] = 216;
        DetectEncoding.Big5Freq[6][138] = 215;
        DetectEncoding.Big5Freq[12][157] = 214;
        DetectEncoding.Big5Freq[10][102] = 213;
        DetectEncoding.Big5Freq[19][94] = 212;
        DetectEncoding.Big5Freq[7][74] = 211;
        DetectEncoding.Big5Freq[18][128] = 210;
        DetectEncoding.Big5Freq[27][111] = 209;
        DetectEncoding.Big5Freq[11][57] = 208;
        DetectEncoding.Big5Freq[3][131] = 207;
        DetectEncoding.Big5Freq[30][23] = 206;
        DetectEncoding.Big5Freq[30][126] = 205;
        DetectEncoding.Big5Freq[4][36] = 204;
        DetectEncoding.Big5Freq[26][124] = 203;
        DetectEncoding.Big5Freq[4][19] = 202;
        DetectEncoding.Big5Freq[9][152] = 201;
        DetectEncoding.EUC_TWFreq[48][49] = 599;
        DetectEncoding.EUC_TWFreq[35][65] = 598;
        DetectEncoding.EUC_TWFreq[41][27] = 597;
        DetectEncoding.EUC_TWFreq[35][0] = 596;
        DetectEncoding.EUC_TWFreq[39][19] = 595;
        DetectEncoding.EUC_TWFreq[35][42] = 594;
        DetectEncoding.EUC_TWFreq[38][66] = 593;
        DetectEncoding.EUC_TWFreq[35][8] = 592;
        DetectEncoding.EUC_TWFreq[35][6] = 591;
        DetectEncoding.EUC_TWFreq[35][66] = 590;
        DetectEncoding.EUC_TWFreq[43][14] = 589;
        DetectEncoding.EUC_TWFreq[69][80] = 588;
        DetectEncoding.EUC_TWFreq[50][48] = 587;
        DetectEncoding.EUC_TWFreq[36][71] = 586;
        DetectEncoding.EUC_TWFreq[37][10] = 585;
        DetectEncoding.EUC_TWFreq[60][52] = 584;
        DetectEncoding.EUC_TWFreq[51][21] = 583;
        DetectEncoding.EUC_TWFreq[40][2] = 582;
        DetectEncoding.EUC_TWFreq[67][35] = 581;
        DetectEncoding.EUC_TWFreq[38][78] = 580;
        DetectEncoding.EUC_TWFreq[49][18] = 579;
        DetectEncoding.EUC_TWFreq[35][23] = 578;
        DetectEncoding.EUC_TWFreq[42][83] = 577;
        DetectEncoding.EUC_TWFreq[79][47] = 576;
        DetectEncoding.EUC_TWFreq[61][82] = 575;
        DetectEncoding.EUC_TWFreq[38][7] = 574;
        DetectEncoding.EUC_TWFreq[35][29] = 573;
        DetectEncoding.EUC_TWFreq[37][77] = 572;
        DetectEncoding.EUC_TWFreq[54][67] = 571;
        DetectEncoding.EUC_TWFreq[38][80] = 570;
        DetectEncoding.EUC_TWFreq[52][74] = 569;
        DetectEncoding.EUC_TWFreq[36][37] = 568;
        DetectEncoding.EUC_TWFreq[74][8] = 567;
        DetectEncoding.EUC_TWFreq[41][83] = 566;
        DetectEncoding.EUC_TWFreq[36][75] = 565;
        DetectEncoding.EUC_TWFreq[49][63] = 564;
        DetectEncoding.EUC_TWFreq[42][58] = 563;
        DetectEncoding.EUC_TWFreq[56][33] = 562;
        DetectEncoding.EUC_TWFreq[37][76] = 561;
        DetectEncoding.EUC_TWFreq[62][39] = 560;
        DetectEncoding.EUC_TWFreq[35][21] = 559;
        DetectEncoding.EUC_TWFreq[70][19] = 558;
        DetectEncoding.EUC_TWFreq[77][88] = 557;
        DetectEncoding.EUC_TWFreq[51][14] = 556;
        DetectEncoding.EUC_TWFreq[36][17] = 555;
        DetectEncoding.EUC_TWFreq[44][51] = 554;
        DetectEncoding.EUC_TWFreq[38][72] = 553;
        DetectEncoding.EUC_TWFreq[74][90] = 552;
        DetectEncoding.EUC_TWFreq[35][48] = 551;
        DetectEncoding.EUC_TWFreq[35][69] = 550;
        DetectEncoding.EUC_TWFreq[66][86] = 549;
        DetectEncoding.EUC_TWFreq[57][20] = 548;
        DetectEncoding.EUC_TWFreq[35][53] = 547;
        DetectEncoding.EUC_TWFreq[36][87] = 546;
        DetectEncoding.EUC_TWFreq[84][67] = 545;
        DetectEncoding.EUC_TWFreq[70][56] = 544;
        DetectEncoding.EUC_TWFreq[71][54] = 543;
        DetectEncoding.EUC_TWFreq[60][70] = 542;
        DetectEncoding.EUC_TWFreq[80][1] = 541;
        DetectEncoding.EUC_TWFreq[39][59] = 540;
        DetectEncoding.EUC_TWFreq[39][51] = 539;
        DetectEncoding.EUC_TWFreq[35][44] = 538;
        DetectEncoding.EUC_TWFreq[48][4] = 537;
        DetectEncoding.EUC_TWFreq[55][24] = 536;
        DetectEncoding.EUC_TWFreq[52][4] = 535;
        DetectEncoding.EUC_TWFreq[54][26] = 534;
        DetectEncoding.EUC_TWFreq[36][31] = 533;
        DetectEncoding.EUC_TWFreq[37][22] = 532;
        DetectEncoding.EUC_TWFreq[37][9] = 531;
        DetectEncoding.EUC_TWFreq[46][0] = 530;
        DetectEncoding.EUC_TWFreq[56][46] = 529;
        DetectEncoding.EUC_TWFreq[47][93] = 528;
        DetectEncoding.EUC_TWFreq[37][25] = 527;
        DetectEncoding.EUC_TWFreq[39][8] = 526;
        DetectEncoding.EUC_TWFreq[46][73] = 525;
        DetectEncoding.EUC_TWFreq[38][48] = 524;
        DetectEncoding.EUC_TWFreq[39][83] = 523;
        DetectEncoding.EUC_TWFreq[60][92] = 522;
        DetectEncoding.EUC_TWFreq[70][11] = 521;
        DetectEncoding.EUC_TWFreq[63][84] = 520;
        DetectEncoding.EUC_TWFreq[38][65] = 519;
        DetectEncoding.EUC_TWFreq[45][45] = 518;
        DetectEncoding.EUC_TWFreq[63][49] = 517;
        DetectEncoding.EUC_TWFreq[63][50] = 516;
        DetectEncoding.EUC_TWFreq[39][93] = 515;
        DetectEncoding.EUC_TWFreq[68][20] = 514;
        DetectEncoding.EUC_TWFreq[44][84] = 513;
        DetectEncoding.EUC_TWFreq[66][34] = 512;
        DetectEncoding.EUC_TWFreq[37][58] = 511;
        DetectEncoding.EUC_TWFreq[39][0] = 510;
        DetectEncoding.EUC_TWFreq[59][1] = 509;
        DetectEncoding.EUC_TWFreq[47][8] = 508;
        DetectEncoding.EUC_TWFreq[61][17] = 507;
        DetectEncoding.EUC_TWFreq[53][87] = 506;
        DetectEncoding.EUC_TWFreq[67][26] = 505;
        DetectEncoding.EUC_TWFreq[43][46] = 504;
        DetectEncoding.EUC_TWFreq[38][61] = 503;
        DetectEncoding.EUC_TWFreq[45][9] = 502;
        DetectEncoding.EUC_TWFreq[66][83] = 501;
        DetectEncoding.EUC_TWFreq[43][88] = 500;
        DetectEncoding.EUC_TWFreq[85][20] = 499;
        DetectEncoding.EUC_TWFreq[57][36] = 498;
        DetectEncoding.EUC_TWFreq[43][6] = 497;
        DetectEncoding.EUC_TWFreq[86][77] = 496;
        DetectEncoding.EUC_TWFreq[42][70] = 495;
        DetectEncoding.EUC_TWFreq[49][78] = 494;
        DetectEncoding.EUC_TWFreq[36][40] = 493;
        DetectEncoding.EUC_TWFreq[42][71] = 492;
        DetectEncoding.EUC_TWFreq[58][49] = 491;
        DetectEncoding.EUC_TWFreq[35][20] = 490;
        DetectEncoding.EUC_TWFreq[76][20] = 489;
        DetectEncoding.EUC_TWFreq[39][25] = 488;
        DetectEncoding.EUC_TWFreq[40][34] = 487;
        DetectEncoding.EUC_TWFreq[39][76] = 486;
        DetectEncoding.EUC_TWFreq[40][1] = 485;
        DetectEncoding.EUC_TWFreq[59][0] = 484;
        DetectEncoding.EUC_TWFreq[39][70] = 483;
        DetectEncoding.EUC_TWFreq[46][14] = 482;
        DetectEncoding.EUC_TWFreq[68][77] = 481;
        DetectEncoding.EUC_TWFreq[38][55] = 480;
        DetectEncoding.EUC_TWFreq[35][78] = 479;
        DetectEncoding.EUC_TWFreq[84][44] = 478;
        DetectEncoding.EUC_TWFreq[36][41] = 477;
        DetectEncoding.EUC_TWFreq[37][62] = 476;
        DetectEncoding.EUC_TWFreq[65][67] = 475;
        DetectEncoding.EUC_TWFreq[69][66] = 474;
        DetectEncoding.EUC_TWFreq[73][55] = 473;
        DetectEncoding.EUC_TWFreq[71][49] = 472;
        DetectEncoding.EUC_TWFreq[66][87] = 471;
        DetectEncoding.EUC_TWFreq[38][33] = 470;
        DetectEncoding.EUC_TWFreq[64][61] = 469;
        DetectEncoding.EUC_TWFreq[35][7] = 468;
        DetectEncoding.EUC_TWFreq[47][49] = 467;
        DetectEncoding.EUC_TWFreq[56][14] = 466;
        DetectEncoding.EUC_TWFreq[36][49] = 465;
        DetectEncoding.EUC_TWFreq[50][81] = 464;
        DetectEncoding.EUC_TWFreq[55][76] = 463;
        DetectEncoding.EUC_TWFreq[35][19] = 462;
        DetectEncoding.EUC_TWFreq[44][47] = 461;
        DetectEncoding.EUC_TWFreq[35][15] = 460;
        DetectEncoding.EUC_TWFreq[82][59] = 459;
        DetectEncoding.EUC_TWFreq[35][43] = 458;
        DetectEncoding.EUC_TWFreq[73][0] = 457;
        DetectEncoding.EUC_TWFreq[57][83] = 456;
        DetectEncoding.EUC_TWFreq[42][46] = 455;
        DetectEncoding.EUC_TWFreq[36][0] = 454;
        DetectEncoding.EUC_TWFreq[70][88] = 453;
        DetectEncoding.EUC_TWFreq[42][22] = 452;
        DetectEncoding.EUC_TWFreq[46][58] = 451;
        DetectEncoding.EUC_TWFreq[36][34] = 450;
        DetectEncoding.EUC_TWFreq[39][24] = 449;
        DetectEncoding.EUC_TWFreq[35][55] = 448;
        DetectEncoding.EUC_TWFreq[44][91] = 447;
        DetectEncoding.EUC_TWFreq[37][51] = 446;
        DetectEncoding.EUC_TWFreq[36][19] = 445;
        DetectEncoding.EUC_TWFreq[69][90] = 444;
        DetectEncoding.EUC_TWFreq[55][35] = 443;
        DetectEncoding.EUC_TWFreq[35][54] = 442;
        DetectEncoding.EUC_TWFreq[49][61] = 441;
        DetectEncoding.EUC_TWFreq[36][67] = 440;
        DetectEncoding.EUC_TWFreq[88][34] = 439;
        DetectEncoding.EUC_TWFreq[35][17] = 438;
        DetectEncoding.EUC_TWFreq[65][69] = 437;
        DetectEncoding.EUC_TWFreq[74][89] = 436;
        DetectEncoding.EUC_TWFreq[37][31] = 435;
        DetectEncoding.EUC_TWFreq[43][48] = 434;
        DetectEncoding.EUC_TWFreq[89][27] = 433;
        DetectEncoding.EUC_TWFreq[42][79] = 432;
        DetectEncoding.EUC_TWFreq[69][57] = 431;
        DetectEncoding.EUC_TWFreq[36][13] = 430;
        DetectEncoding.EUC_TWFreq[35][62] = 429;
        DetectEncoding.EUC_TWFreq[65][47] = 428;
        DetectEncoding.EUC_TWFreq[56][8] = 427;
        DetectEncoding.EUC_TWFreq[38][79] = 426;
        DetectEncoding.EUC_TWFreq[37][64] = 425;
        DetectEncoding.EUC_TWFreq[64][64] = 424;
        DetectEncoding.EUC_TWFreq[38][53] = 423;
        DetectEncoding.EUC_TWFreq[38][31] = 422;
        DetectEncoding.EUC_TWFreq[56][81] = 421;
        DetectEncoding.EUC_TWFreq[36][22] = 420;
        DetectEncoding.EUC_TWFreq[43][4] = 419;
        DetectEncoding.EUC_TWFreq[36][90] = 418;
        DetectEncoding.EUC_TWFreq[38][62] = 417;
        DetectEncoding.EUC_TWFreq[66][85] = 416;
        DetectEncoding.EUC_TWFreq[39][1] = 415;
        DetectEncoding.EUC_TWFreq[59][40] = 414;
        DetectEncoding.EUC_TWFreq[58][93] = 413;
        DetectEncoding.EUC_TWFreq[44][43] = 412;
        DetectEncoding.EUC_TWFreq[39][49] = 411;
        DetectEncoding.EUC_TWFreq[64][2] = 410;
        DetectEncoding.EUC_TWFreq[41][35] = 409;
        DetectEncoding.EUC_TWFreq[60][22] = 408;
        DetectEncoding.EUC_TWFreq[35][91] = 407;
        DetectEncoding.EUC_TWFreq[78][1] = 406;
        DetectEncoding.EUC_TWFreq[36][14] = 405;
        DetectEncoding.EUC_TWFreq[82][29] = 404;
        DetectEncoding.EUC_TWFreq[52][86] = 403;
        DetectEncoding.EUC_TWFreq[40][16] = 402;
        DetectEncoding.EUC_TWFreq[91][52] = 401;
        DetectEncoding.EUC_TWFreq[50][75] = 400;
        DetectEncoding.EUC_TWFreq[64][30] = 399;
        DetectEncoding.EUC_TWFreq[90][78] = 398;
        DetectEncoding.EUC_TWFreq[36][52] = 397;
        DetectEncoding.EUC_TWFreq[55][87] = 396;
        DetectEncoding.EUC_TWFreq[57][5] = 395;
        DetectEncoding.EUC_TWFreq[57][31] = 394;
        DetectEncoding.EUC_TWFreq[42][35] = 393;
        DetectEncoding.EUC_TWFreq[69][50] = 392;
        DetectEncoding.EUC_TWFreq[45][8] = 391;
        DetectEncoding.EUC_TWFreq[50][87] = 390;
        DetectEncoding.EUC_TWFreq[69][55] = 389;
        DetectEncoding.EUC_TWFreq[92][3] = 388;
        DetectEncoding.EUC_TWFreq[36][43] = 387;
        DetectEncoding.EUC_TWFreq[64][10] = 386;
        DetectEncoding.EUC_TWFreq[56][25] = 385;
        DetectEncoding.EUC_TWFreq[60][68] = 384;
        DetectEncoding.EUC_TWFreq[51][46] = 383;
        DetectEncoding.EUC_TWFreq[50][0] = 382;
        DetectEncoding.EUC_TWFreq[38][30] = 381;
        DetectEncoding.EUC_TWFreq[50][85] = 380;
        DetectEncoding.EUC_TWFreq[60][54] = 379;
        DetectEncoding.EUC_TWFreq[73][6] = 378;
        DetectEncoding.EUC_TWFreq[73][28] = 377;
        DetectEncoding.EUC_TWFreq[56][19] = 376;
        DetectEncoding.EUC_TWFreq[62][69] = 375;
        DetectEncoding.EUC_TWFreq[81][66] = 374;
        DetectEncoding.EUC_TWFreq[40][32] = 373;
        DetectEncoding.EUC_TWFreq[76][31] = 372;
        DetectEncoding.EUC_TWFreq[35][10] = 371;
        DetectEncoding.EUC_TWFreq[41][37] = 370;
        DetectEncoding.EUC_TWFreq[52][82] = 369;
        DetectEncoding.EUC_TWFreq[91][72] = 368;
        DetectEncoding.EUC_TWFreq[37][29] = 367;
        DetectEncoding.EUC_TWFreq[56][30] = 366;
        DetectEncoding.EUC_TWFreq[37][80] = 365;
        DetectEncoding.EUC_TWFreq[81][56] = 364;
        DetectEncoding.EUC_TWFreq[70][3] = 363;
        DetectEncoding.EUC_TWFreq[76][15] = 362;
        DetectEncoding.EUC_TWFreq[46][47] = 361;
        DetectEncoding.EUC_TWFreq[35][88] = 360;
        DetectEncoding.EUC_TWFreq[61][58] = 359;
        DetectEncoding.EUC_TWFreq[37][37] = 358;
        DetectEncoding.EUC_TWFreq[57][22] = 357;
        DetectEncoding.EUC_TWFreq[41][23] = 356;
        DetectEncoding.EUC_TWFreq[90][66] = 355;
        DetectEncoding.EUC_TWFreq[39][60] = 354;
        DetectEncoding.EUC_TWFreq[38][0] = 353;
        DetectEncoding.EUC_TWFreq[37][87] = 352;
        DetectEncoding.EUC_TWFreq[46][2] = 351;
        DetectEncoding.EUC_TWFreq[38][56] = 350;
        DetectEncoding.EUC_TWFreq[58][11] = 349;
        DetectEncoding.EUC_TWFreq[48][10] = 348;
        DetectEncoding.EUC_TWFreq[74][4] = 347;
        DetectEncoding.EUC_TWFreq[40][42] = 346;
        DetectEncoding.EUC_TWFreq[41][52] = 345;
        DetectEncoding.EUC_TWFreq[61][92] = 344;
        DetectEncoding.EUC_TWFreq[39][50] = 343;
        DetectEncoding.EUC_TWFreq[47][88] = 342;
        DetectEncoding.EUC_TWFreq[88][36] = 341;
        DetectEncoding.EUC_TWFreq[45][73] = 340;
        DetectEncoding.EUC_TWFreq[82][3] = 339;
        DetectEncoding.EUC_TWFreq[61][36] = 338;
        DetectEncoding.EUC_TWFreq[60][33] = 337;
        DetectEncoding.EUC_TWFreq[38][27] = 336;
        DetectEncoding.EUC_TWFreq[35][83] = 335;
        DetectEncoding.EUC_TWFreq[65][24] = 334;
        DetectEncoding.EUC_TWFreq[73][10] = 333;
        DetectEncoding.EUC_TWFreq[41][13] = 332;
        DetectEncoding.EUC_TWFreq[50][27] = 331;
        DetectEncoding.EUC_TWFreq[59][50] = 330;
        DetectEncoding.EUC_TWFreq[42][45] = 329;
        DetectEncoding.EUC_TWFreq[55][19] = 328;
        DetectEncoding.EUC_TWFreq[36][77] = 327;
        DetectEncoding.EUC_TWFreq[69][31] = 326;
        DetectEncoding.EUC_TWFreq[60][7] = 325;
        DetectEncoding.EUC_TWFreq[40][88] = 324;
        DetectEncoding.EUC_TWFreq[57][56] = 323;
        DetectEncoding.EUC_TWFreq[50][50] = 322;
        DetectEncoding.EUC_TWFreq[42][37] = 321;
        DetectEncoding.EUC_TWFreq[38][82] = 320;
        DetectEncoding.EUC_TWFreq[52][25] = 319;
        DetectEncoding.EUC_TWFreq[42][67] = 318;
        DetectEncoding.EUC_TWFreq[48][40] = 317;
        DetectEncoding.EUC_TWFreq[45][81] = 316;
        DetectEncoding.EUC_TWFreq[57][14] = 315;
        DetectEncoding.EUC_TWFreq[42][13] = 314;
        DetectEncoding.EUC_TWFreq[78][0] = 313;
        DetectEncoding.EUC_TWFreq[35][51] = 312;
        DetectEncoding.EUC_TWFreq[41][67] = 311;
        DetectEncoding.EUC_TWFreq[64][23] = 310;
        DetectEncoding.EUC_TWFreq[36][65] = 309;
        DetectEncoding.EUC_TWFreq[48][50] = 308;
        DetectEncoding.EUC_TWFreq[46][69] = 307;
        DetectEncoding.EUC_TWFreq[47][89] = 306;
        DetectEncoding.EUC_TWFreq[41][48] = 305;
        DetectEncoding.EUC_TWFreq[60][56] = 304;
        DetectEncoding.EUC_TWFreq[44][82] = 303;
        DetectEncoding.EUC_TWFreq[47][35] = 302;
        DetectEncoding.EUC_TWFreq[49][3] = 301;
        DetectEncoding.EUC_TWFreq[49][69] = 300;
        DetectEncoding.EUC_TWFreq[45][93] = 299;
        DetectEncoding.EUC_TWFreq[60][34] = 298;
        DetectEncoding.EUC_TWFreq[60][82] = 297;
        DetectEncoding.EUC_TWFreq[61][61] = 296;
        DetectEncoding.EUC_TWFreq[86][42] = 295;
        DetectEncoding.EUC_TWFreq[89][60] = 294;
        DetectEncoding.EUC_TWFreq[48][31] = 293;
        DetectEncoding.EUC_TWFreq[35][75] = 292;
        DetectEncoding.EUC_TWFreq[91][39] = 291;
        DetectEncoding.EUC_TWFreq[53][19] = 290;
        DetectEncoding.EUC_TWFreq[39][72] = 289;
        DetectEncoding.EUC_TWFreq[69][59] = 288;
        DetectEncoding.EUC_TWFreq[41][7] = 287;
        DetectEncoding.EUC_TWFreq[54][13] = 286;
        DetectEncoding.EUC_TWFreq[43][28] = 285;
        DetectEncoding.EUC_TWFreq[36][6] = 284;
        DetectEncoding.EUC_TWFreq[45][75] = 283;
        DetectEncoding.EUC_TWFreq[36][61] = 282;
        DetectEncoding.EUC_TWFreq[38][21] = 281;
        DetectEncoding.EUC_TWFreq[45][14] = 280;
        DetectEncoding.EUC_TWFreq[61][43] = 279;
        DetectEncoding.EUC_TWFreq[36][63] = 278;
        DetectEncoding.EUC_TWFreq[43][30] = 277;
        DetectEncoding.EUC_TWFreq[46][51] = 276;
        DetectEncoding.EUC_TWFreq[68][87] = 275;
        DetectEncoding.EUC_TWFreq[39][26] = 274;
        DetectEncoding.EUC_TWFreq[46][76] = 273;
        DetectEncoding.EUC_TWFreq[36][15] = 272;
        DetectEncoding.EUC_TWFreq[35][40] = 271;
        DetectEncoding.EUC_TWFreq[79][60] = 270;
        DetectEncoding.EUC_TWFreq[46][7] = 269;
        DetectEncoding.EUC_TWFreq[65][72] = 268;
        DetectEncoding.EUC_TWFreq[69][88] = 267;
        DetectEncoding.EUC_TWFreq[47][18] = 266;
        DetectEncoding.EUC_TWFreq[37][0] = 265;
        DetectEncoding.EUC_TWFreq[37][49] = 264;
        DetectEncoding.EUC_TWFreq[67][37] = 263;
        DetectEncoding.EUC_TWFreq[36][91] = 262;
        DetectEncoding.EUC_TWFreq[75][48] = 261;
        DetectEncoding.EUC_TWFreq[75][63] = 260;
        DetectEncoding.EUC_TWFreq[83][87] = 259;
        DetectEncoding.EUC_TWFreq[37][44] = 258;
        DetectEncoding.EUC_TWFreq[73][54] = 257;
        DetectEncoding.EUC_TWFreq[51][61] = 256;
        DetectEncoding.EUC_TWFreq[46][57] = 255;
        DetectEncoding.EUC_TWFreq[55][21] = 254;
        DetectEncoding.EUC_TWFreq[39][66] = 253;
        DetectEncoding.EUC_TWFreq[47][11] = 252;
        DetectEncoding.EUC_TWFreq[52][8] = 251;
        DetectEncoding.EUC_TWFreq[82][81] = 250;
        DetectEncoding.EUC_TWFreq[36][57] = 249;
        DetectEncoding.EUC_TWFreq[38][54] = 248;
        DetectEncoding.EUC_TWFreq[43][81] = 247;
        DetectEncoding.EUC_TWFreq[37][42] = 246;
        DetectEncoding.EUC_TWFreq[40][18] = 245;
        DetectEncoding.EUC_TWFreq[80][90] = 244;
        DetectEncoding.EUC_TWFreq[37][84] = 243;
        DetectEncoding.EUC_TWFreq[57][15] = 242;
        DetectEncoding.EUC_TWFreq[38][87] = 241;
        DetectEncoding.EUC_TWFreq[37][32] = 240;
        DetectEncoding.EUC_TWFreq[53][53] = 239;
        DetectEncoding.EUC_TWFreq[89][29] = 238;
        DetectEncoding.EUC_TWFreq[81][53] = 237;
        DetectEncoding.EUC_TWFreq[75][3] = 236;
        DetectEncoding.EUC_TWFreq[83][73] = 235;
        DetectEncoding.EUC_TWFreq[66][13] = 234;
        DetectEncoding.EUC_TWFreq[48][7] = 233;
        DetectEncoding.EUC_TWFreq[46][35] = 232;
        DetectEncoding.EUC_TWFreq[35][86] = 231;
        DetectEncoding.EUC_TWFreq[37][20] = 230;
        DetectEncoding.EUC_TWFreq[46][80] = 229;
        DetectEncoding.EUC_TWFreq[38][24] = 228;
        DetectEncoding.EUC_TWFreq[41][68] = 227;
        DetectEncoding.EUC_TWFreq[42][21] = 226;
        DetectEncoding.EUC_TWFreq[43][32] = 225;
        DetectEncoding.EUC_TWFreq[38][20] = 224;
        DetectEncoding.EUC_TWFreq[37][59] = 223;
        DetectEncoding.EUC_TWFreq[41][77] = 222;
        DetectEncoding.EUC_TWFreq[59][57] = 221;
        DetectEncoding.EUC_TWFreq[68][59] = 220;
        DetectEncoding.EUC_TWFreq[39][43] = 219;
        DetectEncoding.EUC_TWFreq[54][39] = 218;
        DetectEncoding.EUC_TWFreq[48][28] = 217;
        DetectEncoding.EUC_TWFreq[54][28] = 216;
        DetectEncoding.EUC_TWFreq[41][44] = 215;
        DetectEncoding.EUC_TWFreq[51][64] = 214;
        DetectEncoding.EUC_TWFreq[47][72] = 213;
        DetectEncoding.EUC_TWFreq[62][67] = 212;
        DetectEncoding.EUC_TWFreq[42][43] = 211;
        DetectEncoding.EUC_TWFreq[61][38] = 210;
        DetectEncoding.EUC_TWFreq[76][25] = 209;
        DetectEncoding.EUC_TWFreq[48][91] = 208;
        DetectEncoding.EUC_TWFreq[36][36] = 207;
        DetectEncoding.EUC_TWFreq[80][32] = 206;
        DetectEncoding.EUC_TWFreq[81][40] = 205;
        DetectEncoding.EUC_TWFreq[37][5] = 204;
        DetectEncoding.EUC_TWFreq[74][69] = 203;
        DetectEncoding.EUC_TWFreq[36][82] = 202;
        DetectEncoding.EUC_TWFreq[46][59] = 201;
        DetectEncoding.GBKFreq[52][132] = 600;
        DetectEncoding.GBKFreq[73][135] = 599;
        DetectEncoding.GBKFreq[49][123] = 598;
        DetectEncoding.GBKFreq[77][146] = 597;
        DetectEncoding.GBKFreq[81][123] = 596;
        DetectEncoding.GBKFreq[82][144] = 595;
        DetectEncoding.GBKFreq[51][179] = 594;
        DetectEncoding.GBKFreq[83][154] = 593;
        DetectEncoding.GBKFreq[71][139] = 592;
        DetectEncoding.GBKFreq[64][139] = 591;
        DetectEncoding.GBKFreq[85][144] = 590;
        DetectEncoding.GBKFreq[52][125] = 589;
        DetectEncoding.GBKFreq[88][25] = 588;
        DetectEncoding.GBKFreq[81][106] = 587;
        DetectEncoding.GBKFreq[81][148] = 586;
        DetectEncoding.GBKFreq[62][137] = 585;
        DetectEncoding.GBKFreq[94][0] = 584;
        DetectEncoding.GBKFreq[1][64] = 583;
        DetectEncoding.GBKFreq[67][163] = 582;
        DetectEncoding.GBKFreq[20][190] = 581;
        DetectEncoding.GBKFreq[57][131] = 580;
        DetectEncoding.GBKFreq[29][169] = 579;
        DetectEncoding.GBKFreq[72][143] = 578;
        DetectEncoding.GBKFreq[0][173] = 577;
        DetectEncoding.GBKFreq[11][23] = 576;
        DetectEncoding.GBKFreq[61][141] = 575;
        DetectEncoding.GBKFreq[60][123] = 574;
        DetectEncoding.GBKFreq[81][114] = 573;
        DetectEncoding.GBKFreq[82][131] = 572;
        DetectEncoding.GBKFreq[67][156] = 571;
        DetectEncoding.GBKFreq[71][167] = 570;
        DetectEncoding.GBKFreq[20][50] = 569;
        DetectEncoding.GBKFreq[77][132] = 568;
        DetectEncoding.GBKFreq[84][38] = 567;
        DetectEncoding.GBKFreq[26][29] = 566;
        DetectEncoding.GBKFreq[74][187] = 565;
        DetectEncoding.GBKFreq[62][116] = 564;
        DetectEncoding.GBKFreq[67][135] = 563;
        DetectEncoding.GBKFreq[5][86] = 562;
        DetectEncoding.GBKFreq[72][186] = 561;
        DetectEncoding.GBKFreq[75][161] = 560;
        DetectEncoding.GBKFreq[78][130] = 559;
        DetectEncoding.GBKFreq[94][30] = 558;
        DetectEncoding.GBKFreq[84][72] = 557;
        DetectEncoding.GBKFreq[1][67] = 556;
        DetectEncoding.GBKFreq[75][172] = 555;
        DetectEncoding.GBKFreq[74][185] = 554;
        DetectEncoding.GBKFreq[53][160] = 553;
        DetectEncoding.GBKFreq[123][14] = 552;
        DetectEncoding.GBKFreq[79][97] = 551;
        DetectEncoding.GBKFreq[85][110] = 550;
        DetectEncoding.GBKFreq[78][171] = 549;
        DetectEncoding.GBKFreq[52][131] = 548;
        DetectEncoding.GBKFreq[56][100] = 547;
        DetectEncoding.GBKFreq[50][182] = 546;
        DetectEncoding.GBKFreq[94][64] = 545;
        DetectEncoding.GBKFreq[106][74] = 544;
        DetectEncoding.GBKFreq[11][102] = 543;
        DetectEncoding.GBKFreq[53][124] = 542;
        DetectEncoding.GBKFreq[24][3] = 541;
        DetectEncoding.GBKFreq[86][148] = 540;
        DetectEncoding.GBKFreq[53][184] = 539;
        DetectEncoding.GBKFreq[86][147] = 538;
        DetectEncoding.GBKFreq[96][161] = 537;
        DetectEncoding.GBKFreq[82][77] = 536;
        DetectEncoding.GBKFreq[59][146] = 535;
        DetectEncoding.GBKFreq[84][126] = 534;
        DetectEncoding.GBKFreq[79][132] = 533;
        DetectEncoding.GBKFreq[85][123] = 532;
        DetectEncoding.GBKFreq[71][101] = 531;
        DetectEncoding.GBKFreq[85][106] = 530;
        DetectEncoding.GBKFreq[6][184] = 529;
        DetectEncoding.GBKFreq[57][156] = 528;
        DetectEncoding.GBKFreq[75][104] = 527;
        DetectEncoding.GBKFreq[50][137] = 526;
        DetectEncoding.GBKFreq[79][133] = 525;
        DetectEncoding.GBKFreq[76][108] = 524;
        DetectEncoding.GBKFreq[57][142] = 523;
        DetectEncoding.GBKFreq[84][130] = 522;
        DetectEncoding.GBKFreq[52][128] = 521;
        DetectEncoding.GBKFreq[47][44] = 520;
        DetectEncoding.GBKFreq[52][152] = 519;
        DetectEncoding.GBKFreq[54][104] = 518;
        DetectEncoding.GBKFreq[30][47] = 517;
        DetectEncoding.GBKFreq[71][123] = 516;
        DetectEncoding.GBKFreq[52][107] = 515;
        DetectEncoding.GBKFreq[45][84] = 514;
        DetectEncoding.GBKFreq[107][118] = 513;
        DetectEncoding.GBKFreq[5][161] = 512;
        DetectEncoding.GBKFreq[48][126] = 511;
        DetectEncoding.GBKFreq[67][170] = 510;
        DetectEncoding.GBKFreq[43][6] = 509;
        DetectEncoding.GBKFreq[70][112] = 508;
        DetectEncoding.GBKFreq[86][174] = 507;
        DetectEncoding.GBKFreq[84][166] = 506;
        DetectEncoding.GBKFreq[79][130] = 505;
        DetectEncoding.GBKFreq[57][141] = 504;
        DetectEncoding.GBKFreq[81][178] = 503;
        DetectEncoding.GBKFreq[56][187] = 502;
        DetectEncoding.GBKFreq[81][162] = 501;
        DetectEncoding.GBKFreq[53][104] = 500;
        DetectEncoding.GBKFreq[123][35] = 499;
        DetectEncoding.GBKFreq[70][169] = 498;
        DetectEncoding.GBKFreq[69][164] = 497;
        DetectEncoding.GBKFreq[109][61] = 496;
        DetectEncoding.GBKFreq[73][130] = 495;
        DetectEncoding.GBKFreq[62][134] = 494;
        DetectEncoding.GBKFreq[54][125] = 493;
        DetectEncoding.GBKFreq[79][105] = 492;
        DetectEncoding.GBKFreq[70][165] = 491;
        DetectEncoding.GBKFreq[71][189] = 490;
        DetectEncoding.GBKFreq[23][147] = 489;
        DetectEncoding.GBKFreq[51][139] = 488;
        DetectEncoding.GBKFreq[47][137] = 487;
        DetectEncoding.GBKFreq[77][123] = 486;
        DetectEncoding.GBKFreq[86][183] = 485;
        DetectEncoding.GBKFreq[63][173] = 484;
        DetectEncoding.GBKFreq[79][144] = 483;
        DetectEncoding.GBKFreq[84][159] = 482;
        DetectEncoding.GBKFreq[60][91] = 481;
        DetectEncoding.GBKFreq[66][187] = 480;
        DetectEncoding.GBKFreq[73][114] = 479;
        DetectEncoding.GBKFreq[85][56] = 478;
        DetectEncoding.GBKFreq[71][149] = 477;
        DetectEncoding.GBKFreq[84][189] = 476;
        DetectEncoding.GBKFreq[104][31] = 475;
        DetectEncoding.GBKFreq[83][82] = 474;
        DetectEncoding.GBKFreq[68][35] = 473;
        DetectEncoding.GBKFreq[11][77] = 472;
        DetectEncoding.GBKFreq[15][155] = 471;
        DetectEncoding.GBKFreq[83][153] = 470;
        DetectEncoding.GBKFreq[71][1] = 469;
        DetectEncoding.GBKFreq[53][190] = 468;
        DetectEncoding.GBKFreq[50][135] = 467;
        DetectEncoding.GBKFreq[3][147] = 466;
        DetectEncoding.GBKFreq[48][136] = 465;
        DetectEncoding.GBKFreq[66][166] = 464;
        DetectEncoding.GBKFreq[55][159] = 463;
        DetectEncoding.GBKFreq[82][150] = 462;
        DetectEncoding.GBKFreq[58][178] = 461;
        DetectEncoding.GBKFreq[64][102] = 460;
        DetectEncoding.GBKFreq[16][106] = 459;
        DetectEncoding.GBKFreq[68][110] = 458;
        DetectEncoding.GBKFreq[54][14] = 457;
        DetectEncoding.GBKFreq[60][140] = 456;
        DetectEncoding.GBKFreq[91][71] = 455;
        DetectEncoding.GBKFreq[54][150] = 454;
        DetectEncoding.GBKFreq[78][177] = 453;
        DetectEncoding.GBKFreq[78][117] = 452;
        DetectEncoding.GBKFreq[104][12] = 451;
        DetectEncoding.GBKFreq[73][150] = 450;
        DetectEncoding.GBKFreq[51][142] = 449;
        DetectEncoding.GBKFreq[81][145] = 448;
        DetectEncoding.GBKFreq[66][183] = 447;
        DetectEncoding.GBKFreq[51][178] = 446;
        DetectEncoding.GBKFreq[75][107] = 445;
        DetectEncoding.GBKFreq[65][119] = 444;
        DetectEncoding.GBKFreq[69][176] = 443;
        DetectEncoding.GBKFreq[59][122] = 442;
        DetectEncoding.GBKFreq[78][160] = 441;
        DetectEncoding.GBKFreq[85][183] = 440;
        DetectEncoding.GBKFreq[105][16] = 439;
        DetectEncoding.GBKFreq[73][110] = 438;
        DetectEncoding.GBKFreq[104][39] = 437;
        DetectEncoding.GBKFreq[119][16] = 436;
        DetectEncoding.GBKFreq[76][162] = 435;
        DetectEncoding.GBKFreq[67][152] = 434;
        DetectEncoding.GBKFreq[82][24] = 433;
        DetectEncoding.GBKFreq[73][121] = 432;
        DetectEncoding.GBKFreq[83][83] = 431;
        DetectEncoding.GBKFreq[82][145] = 430;
        DetectEncoding.GBKFreq[49][133] = 429;
        DetectEncoding.GBKFreq[94][13] = 428;
        DetectEncoding.GBKFreq[58][139] = 427;
        DetectEncoding.GBKFreq[74][189] = 426;
        DetectEncoding.GBKFreq[66][177] = 425;
        DetectEncoding.GBKFreq[85][184] = 424;
        DetectEncoding.GBKFreq[55][183] = 423;
        DetectEncoding.GBKFreq[71][107] = 422;
        DetectEncoding.GBKFreq[11][98] = 421;
        DetectEncoding.GBKFreq[72][153] = 420;
        DetectEncoding.GBKFreq[2][137] = 419;
        DetectEncoding.GBKFreq[59][147] = 418;
        DetectEncoding.GBKFreq[58][152] = 417;
        DetectEncoding.GBKFreq[55][144] = 416;
        DetectEncoding.GBKFreq[73][125] = 415;
        DetectEncoding.GBKFreq[52][154] = 414;
        DetectEncoding.GBKFreq[70][178] = 413;
        DetectEncoding.GBKFreq[79][148] = 412;
        DetectEncoding.GBKFreq[63][143] = 411;
        DetectEncoding.GBKFreq[50][140] = 410;
        DetectEncoding.GBKFreq[47][145] = 409;
        DetectEncoding.GBKFreq[48][123] = 408;
        DetectEncoding.GBKFreq[56][107] = 407;
        DetectEncoding.GBKFreq[84][83] = 406;
        DetectEncoding.GBKFreq[59][112] = 405;
        DetectEncoding.GBKFreq[124][72] = 404;
        DetectEncoding.GBKFreq[79][99] = 403;
        DetectEncoding.GBKFreq[3][37] = 402;
        DetectEncoding.GBKFreq[114][55] = 401;
        DetectEncoding.GBKFreq[85][152] = 400;
        DetectEncoding.GBKFreq[60][47] = 399;
        DetectEncoding.GBKFreq[65][96] = 398;
        DetectEncoding.GBKFreq[74][110] = 397;
        DetectEncoding.GBKFreq[86][182] = 396;
        DetectEncoding.GBKFreq[50][99] = 395;
        DetectEncoding.GBKFreq[67][186] = 394;
        DetectEncoding.GBKFreq[81][74] = 393;
        DetectEncoding.GBKFreq[80][37] = 392;
        DetectEncoding.GBKFreq[21][60] = 391;
        DetectEncoding.GBKFreq[110][12] = 390;
        DetectEncoding.GBKFreq[60][162] = 389;
        DetectEncoding.GBKFreq[29][115] = 388;
        DetectEncoding.GBKFreq[83][130] = 387;
        DetectEncoding.GBKFreq[52][136] = 386;
        DetectEncoding.GBKFreq[63][114] = 385;
        DetectEncoding.GBKFreq[49][127] = 384;
        DetectEncoding.GBKFreq[83][109] = 383;
        DetectEncoding.GBKFreq[66][128] = 382;
        DetectEncoding.GBKFreq[78][136] = 381;
        DetectEncoding.GBKFreq[81][180] = 380;
        DetectEncoding.GBKFreq[76][104] = 379;
        DetectEncoding.GBKFreq[56][156] = 378;
        DetectEncoding.GBKFreq[61][23] = 377;
        DetectEncoding.GBKFreq[4][30] = 376;
        DetectEncoding.GBKFreq[69][154] = 375;
        DetectEncoding.GBKFreq[100][37] = 374;
        DetectEncoding.GBKFreq[54][177] = 373;
        DetectEncoding.GBKFreq[23][119] = 372;
        DetectEncoding.GBKFreq[71][171] = 371;
        DetectEncoding.GBKFreq[84][146] = 370;
        DetectEncoding.GBKFreq[20][184] = 369;
        DetectEncoding.GBKFreq[86][76] = 368;
        DetectEncoding.GBKFreq[74][132] = 367;
        DetectEncoding.GBKFreq[47][97] = 366;
        DetectEncoding.GBKFreq[82][137] = 365;
        DetectEncoding.GBKFreq[94][56] = 364;
        DetectEncoding.GBKFreq[92][30] = 363;
        DetectEncoding.GBKFreq[19][117] = 362;
        DetectEncoding.GBKFreq[48][173] = 361;
        DetectEncoding.GBKFreq[2][136] = 360;
        DetectEncoding.GBKFreq[7][182] = 359;
        DetectEncoding.GBKFreq[74][188] = 358;
        DetectEncoding.GBKFreq[14][132] = 357;
        DetectEncoding.GBKFreq[62][172] = 356;
        DetectEncoding.GBKFreq[25][39] = 355;
        DetectEncoding.GBKFreq[85][129] = 354;
        DetectEncoding.GBKFreq[64][98] = 353;
        DetectEncoding.GBKFreq[67][127] = 352;
        DetectEncoding.GBKFreq[72][167] = 351;
        DetectEncoding.GBKFreq[57][143] = 350;
        DetectEncoding.GBKFreq[76][187] = 349;
        DetectEncoding.GBKFreq[83][181] = 348;
        DetectEncoding.GBKFreq[84][10] = 347;
        DetectEncoding.GBKFreq[55][166] = 346;
        DetectEncoding.GBKFreq[55][188] = 345;
        DetectEncoding.GBKFreq[13][151] = 344;
        DetectEncoding.GBKFreq[62][124] = 343;
        DetectEncoding.GBKFreq[53][136] = 342;
        DetectEncoding.GBKFreq[106][57] = 341;
        DetectEncoding.GBKFreq[47][166] = 340;
        DetectEncoding.GBKFreq[109][30] = 339;
        DetectEncoding.GBKFreq[78][114] = 338;
        DetectEncoding.GBKFreq[83][19] = 337;
        DetectEncoding.GBKFreq[56][162] = 336;
        DetectEncoding.GBKFreq[60][177] = 335;
        DetectEncoding.GBKFreq[88][9] = 334;
        DetectEncoding.GBKFreq[74][163] = 333;
        DetectEncoding.GBKFreq[52][156] = 332;
        DetectEncoding.GBKFreq[71][180] = 331;
        DetectEncoding.GBKFreq[60][57] = 330;
        DetectEncoding.GBKFreq[72][173] = 329;
        DetectEncoding.GBKFreq[82][91] = 328;
        DetectEncoding.GBKFreq[51][186] = 327;
        DetectEncoding.GBKFreq[75][86] = 326;
        DetectEncoding.GBKFreq[75][78] = 325;
        DetectEncoding.GBKFreq[76][170] = 324;
        DetectEncoding.GBKFreq[60][147] = 323;
        DetectEncoding.GBKFreq[82][75] = 322;
        DetectEncoding.GBKFreq[80][148] = 321;
        DetectEncoding.GBKFreq[86][150] = 320;
        DetectEncoding.GBKFreq[13][95] = 319;
        DetectEncoding.GBKFreq[0][11] = 318;
        DetectEncoding.GBKFreq[84][190] = 317;
        DetectEncoding.GBKFreq[76][166] = 316;
        DetectEncoding.GBKFreq[14][72] = 315;
        DetectEncoding.GBKFreq[67][144] = 314;
        DetectEncoding.GBKFreq[84][44] = 313;
        DetectEncoding.GBKFreq[72][125] = 312;
        DetectEncoding.GBKFreq[66][127] = 311;
        DetectEncoding.GBKFreq[60][25] = 310;
        DetectEncoding.GBKFreq[70][146] = 309;
        DetectEncoding.GBKFreq[79][135] = 308;
        DetectEncoding.GBKFreq[54][135] = 307;
        DetectEncoding.GBKFreq[60][104] = 306;
        DetectEncoding.GBKFreq[55][132] = 305;
        DetectEncoding.GBKFreq[94][2] = 304;
        DetectEncoding.GBKFreq[54][133] = 303;
        DetectEncoding.GBKFreq[56][190] = 302;
        DetectEncoding.GBKFreq[58][174] = 301;
        DetectEncoding.GBKFreq[80][144] = 300;
        DetectEncoding.GBKFreq[85][113] = 299;
    }

    static {
        Charset charset;
        GBFreq = new int[94][94];
        GBKFreq = new int[126][191];
        Big5Freq = new int[94][158];
        EUC_TWFreq = new int[94][94];
        CHARSET_UTF8 = Charset.forName("UTF-8");
        CHARSET_GB2312 = Charset.forName("GB2312");
        CHARSET_GBK = Charset.forName("GBK");
        CHARSET_UNICODE = Charset.forName("Unicode");
        CHARSET_BIG5 = Charset.forName("Big5");
        try {
            charset = Charset.forName("EUC-TW");
        }
        catch (UnsupportedCharsetException ignored) {
            charset = CHARSET_UTF8;
        }
        CHARSET_EUC_TW = charset;
        encodeCharset = new Charset[8];
        DetectEncoding.encodeCharset[0] = CHARSET_UTF8;
        DetectEncoding.encodeCharset[1] = CHARSET_GB2312;
        DetectEncoding.encodeCharset[2] = CHARSET_GBK;
        DetectEncoding.encodeCharset[3] = CHARSET_UNICODE;
        DetectEncoding.encodeCharset[4] = CHARSET_GBK;
        DetectEncoding.encodeCharset[5] = CHARSET_BIG5;
        DetectEncoding.encodeCharset[6] = CHARSET_EUC_TW;
        DetectEncoding.encodeCharset[7] = CHARSET_UTF8;
        DetectEncoding.initialize_frequencies();
    }
}

