/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import android.support.annotation.NonNull;
import java.io.IOException;
import java.util.BitSet;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.analysis.MethodAnalyzer;
import org.jf.dexlib2.analysis.RegisterType;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.ThreeRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.util.IndentingWriter;

public class PreInstructionRegisterInfoMethodItem
extends MethodItem {
    private final int registerInfo;
    @NonNull
    private final MethodAnalyzer methodAnalyzer;
    @NonNull
    private final RegisterFormatter registerFormatter;
    @NonNull
    private final AnalyzedInstruction analyzedInstruction;

    public PreInstructionRegisterInfoMethodItem(int registerInfo, @NonNull MethodAnalyzer methodAnalyzer, @NonNull RegisterFormatter registerFormatter, @NonNull AnalyzedInstruction analyzedInstruction, int codeAddress) {
        if (methodAnalyzer == null) {
            PreInstructionRegisterInfoMethodItem.$$$reportNull$$$0(0);
        }
        if (registerFormatter == null) {
            PreInstructionRegisterInfoMethodItem.$$$reportNull$$$0(1);
        }
        if (analyzedInstruction == null) {
            PreInstructionRegisterInfoMethodItem.$$$reportNull$$$0(2);
        }
        super(codeAddress);
        this.registerInfo = registerInfo;
        this.methodAnalyzer = methodAnalyzer;
        this.registerFormatter = registerFormatter;
        this.analyzedInstruction = analyzedInstruction;
    }

    @Override
    public double getSortOrder() {
        return 99.9;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        int registerCount = this.analyzedInstruction.getRegisterCount();
        BitSet registers = new BitSet(registerCount);
        BitSet mergeRegisters = null;
        if ((this.registerInfo & 1) != 0) {
            registers.set(0, registerCount);
        } else if ((this.registerInfo & 2) != 0) {
            registers.set(0, registerCount);
        } else {
            if ((this.registerInfo & 8) != 0) {
                this.addArgsRegs(registers);
            }
            if ((this.registerInfo & 0x20) != 0) {
                if (this.analyzedInstruction.isBeginningInstruction()) {
                    this.addParamRegs(registers, registerCount);
                }
                mergeRegisters = new BitSet(registerCount);
                this.addMergeRegs(mergeRegisters, registerCount);
            } else if ((this.registerInfo & 0x40) != 0 && this.analyzedInstruction.isBeginningInstruction()) {
                this.addParamRegs(registers, registerCount);
            }
        }
        if ((this.registerInfo & 0x40) != 0) {
            if (mergeRegisters == null) {
                mergeRegisters = new BitSet(registerCount);
                this.addMergeRegs(mergeRegisters, registerCount);
            }
            registers.or(mergeRegisters);
        } else if (mergeRegisters != null) {
            registers.or(mergeRegisters);
            mergeRegisters = null;
        }
        return this.writeRegisterInfo(writer, registers, mergeRegisters);
    }

    private void addArgsRegs(BitSet registers) {
        if (this.analyzedInstruction.getInstruction() instanceof RegisterRangeInstruction) {
            RegisterRangeInstruction instruction = (RegisterRangeInstruction)this.analyzedInstruction.getInstruction();
            registers.set(instruction.getStartRegister(), instruction.getStartRegister() + instruction.getRegisterCount());
        } else if (this.analyzedInstruction.getInstruction() instanceof FiveRegisterInstruction) {
            FiveRegisterInstruction instruction = (FiveRegisterInstruction)this.analyzedInstruction.getInstruction();
            int regCount = instruction.getRegisterCount();
            switch (regCount) {
                case 5: {
                    registers.set(instruction.getRegisterG());
                }
                case 4: {
                    registers.set(instruction.getRegisterF());
                }
                case 3: {
                    registers.set(instruction.getRegisterE());
                }
                case 2: {
                    registers.set(instruction.getRegisterD());
                }
                case 1: {
                    registers.set(instruction.getRegisterC());
                }
            }
        } else if (this.analyzedInstruction.getInstruction() instanceof ThreeRegisterInstruction) {
            ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)this.analyzedInstruction.getInstruction();
            registers.set(instruction.getRegisterA());
            registers.set(instruction.getRegisterB());
            registers.set(instruction.getRegisterC());
        } else if (this.analyzedInstruction.getInstruction() instanceof TwoRegisterInstruction) {
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)this.analyzedInstruction.getInstruction();
            registers.set(instruction.getRegisterA());
            registers.set(instruction.getRegisterB());
        } else if (this.analyzedInstruction.getInstruction() instanceof OneRegisterInstruction) {
            OneRegisterInstruction instruction = (OneRegisterInstruction)this.analyzedInstruction.getInstruction();
            registers.set(instruction.getRegisterA());
        }
    }

    private void addMergeRegs(BitSet registers, int registerCount) {
        if (this.analyzedInstruction.getPredecessorCount() <= 1) {
            return;
        }
        for (int registerNum = 0; registerNum < registerCount; ++registerNum) {
            RegisterType mergedRegisterType = this.analyzedInstruction.getPreInstructionRegisterType(registerNum);
            for (AnalyzedInstruction predecessor : this.analyzedInstruction.getPredecessors()) {
                RegisterType predecessorRegisterType = this.analyzedInstruction.getPredecessorRegisterType(predecessor, registerNum);
                if (predecessorRegisterType.category == 0 || predecessorRegisterType.equals(mergedRegisterType)) continue;
                registers.set(registerNum);
            }
        }
    }

    private void addParamRegs(BitSet registers, int registerCount) {
        int parameterRegisterCount = this.methodAnalyzer.getParamRegisterCount();
        registers.set(registerCount - parameterRegisterCount, registerCount);
    }

    private void writeFullMerge(IndentingWriter writer, int registerNum) throws IOException {
        this.registerFormatter.writeTo(writer, registerNum);
        writer.write(61);
        this.analyzedInstruction.getPreInstructionRegisterType(registerNum).writeTo(writer);
        writer.write(":merge{");
        boolean first = true;
        for (AnalyzedInstruction predecessor : this.analyzedInstruction.getPredecessors()) {
            RegisterType predecessorRegisterType = this.analyzedInstruction.getPredecessorRegisterType(predecessor, registerNum);
            if (!first) {
                writer.write(44);
            }
            if (predecessor.getInstructionIndex() == -1) {
                writer.write("Start:");
            } else {
                writer.write("0x");
                writer.printUnsignedLongAsHex(this.methodAnalyzer.getInstructionAddress(predecessor));
                writer.write(58);
            }
            predecessorRegisterType.writeTo(writer);
            first = false;
        }
        writer.write(125);
    }

    private boolean writeRegisterInfo(IndentingWriter writer, BitSet registers, BitSet fullMergeRegisters) throws IOException {
        boolean firstRegister = true;
        boolean previousWasFullMerge = false;
        int registerNum = registers.nextSetBit(0);
        if (registerNum < 0) {
            return false;
        }
        writer.write(35);
        while (registerNum >= 0) {
            boolean fullMerge;
            boolean bl = fullMerge = fullMergeRegisters != null && fullMergeRegisters.get(registerNum);
            if (fullMerge) {
                if (!firstRegister) {
                    writer.write(10);
                    writer.write(35);
                }
                this.writeFullMerge(writer, registerNum);
                previousWasFullMerge = true;
            } else {
                if (previousWasFullMerge) {
                    writer.write(10);
                    writer.write(35);
                    previousWasFullMerge = false;
                }
                RegisterType registerType = this.analyzedInstruction.getPreInstructionRegisterType(registerNum);
                this.registerFormatter.writeTo(writer, registerNum);
                writer.write(61);
                registerType.writeTo(writer);
                writer.write(59);
            }
            firstRegister = false;
            registerNum = registers.nextSetBit(registerNum + 1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "methodAnalyzer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "registerFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "analyzedInstruction";
                break;
            }
        }
        objectArray[1] = "org/jf/baksmali/Adaptors/PreInstructionRegisterInfoMethodItem";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

