/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.analysis.AnalysisException;

public class OdexedFieldInstructionMapper {
    private static final int GET = 0;
    private static final int PUT = 1;
    private static final int INSTANCE = 0;
    private static final int STATIC = 1;
    private static final int PRIMITIVE = 0;
    private static final int WIDE = 1;
    private static final int REFERENCE = 2;
    private static final FieldOpcode[] dalvikFieldOpcodes = new FieldOpcode[]{new FieldOpcode('Z', Opcode.IGET_BOOLEAN, Opcode.IGET_QUICK, Opcode.IGET_VOLATILE), new FieldOpcode('B', Opcode.IGET_BYTE, Opcode.IGET_QUICK, Opcode.IGET_VOLATILE), new FieldOpcode('S', Opcode.IGET_SHORT, Opcode.IGET_QUICK, Opcode.IGET_VOLATILE), new FieldOpcode('C', Opcode.IGET_CHAR, Opcode.IGET_QUICK, Opcode.IGET_VOLATILE), new FieldOpcode('I', Opcode.IGET, Opcode.IGET_QUICK, Opcode.IGET_VOLATILE), new FieldOpcode('F', Opcode.IGET, Opcode.IGET_QUICK, Opcode.IGET_VOLATILE), new FieldOpcode('J', Opcode.IGET_WIDE, Opcode.IGET_WIDE_QUICK, Opcode.IGET_WIDE_VOLATILE), new FieldOpcode('D', Opcode.IGET_WIDE, Opcode.IGET_WIDE_QUICK, Opcode.IGET_WIDE_VOLATILE), new FieldOpcode('L', Opcode.IGET_OBJECT, Opcode.IGET_OBJECT_QUICK, Opcode.IGET_OBJECT_VOLATILE), new FieldOpcode('[', Opcode.IGET_OBJECT, Opcode.IGET_OBJECT_QUICK, Opcode.IGET_OBJECT_VOLATILE), new FieldOpcode('Z', Opcode.IPUT_BOOLEAN, Opcode.IPUT_QUICK, Opcode.IPUT_VOLATILE), new FieldOpcode('B', Opcode.IPUT_BYTE, Opcode.IPUT_QUICK, Opcode.IPUT_VOLATILE), new FieldOpcode('S', Opcode.IPUT_SHORT, Opcode.IPUT_QUICK, Opcode.IPUT_VOLATILE), new FieldOpcode('C', Opcode.IPUT_CHAR, Opcode.IPUT_QUICK, Opcode.IPUT_VOLATILE), new FieldOpcode('I', Opcode.IPUT, Opcode.IPUT_QUICK, Opcode.IPUT_VOLATILE), new FieldOpcode('F', Opcode.IPUT, Opcode.IPUT_QUICK, Opcode.IPUT_VOLATILE), new FieldOpcode('J', Opcode.IPUT_WIDE, Opcode.IPUT_WIDE_QUICK, Opcode.IPUT_WIDE_VOLATILE), new FieldOpcode('D', Opcode.IPUT_WIDE, Opcode.IPUT_WIDE_QUICK, Opcode.IPUT_WIDE_VOLATILE), new FieldOpcode('L', Opcode.IPUT_OBJECT, Opcode.IPUT_OBJECT_QUICK, Opcode.IPUT_OBJECT_VOLATILE), new FieldOpcode('[', Opcode.IPUT_OBJECT, Opcode.IPUT_OBJECT_QUICK, Opcode.IPUT_OBJECT_VOLATILE), new FieldOpcode('Z', true, Opcode.SPUT_BOOLEAN, Opcode.SPUT_VOLATILE), new FieldOpcode('B', true, Opcode.SPUT_BYTE, Opcode.SPUT_VOLATILE), new FieldOpcode('S', true, Opcode.SPUT_SHORT, Opcode.SPUT_VOLATILE), new FieldOpcode('C', true, Opcode.SPUT_CHAR, Opcode.SPUT_VOLATILE), new FieldOpcode('I', true, Opcode.SPUT, Opcode.SPUT_VOLATILE), new FieldOpcode('F', true, Opcode.SPUT, Opcode.SPUT_VOLATILE), new FieldOpcode('J', true, Opcode.SPUT_WIDE, Opcode.SPUT_WIDE_VOLATILE), new FieldOpcode('D', true, Opcode.SPUT_WIDE, Opcode.SPUT_WIDE_VOLATILE), new FieldOpcode('L', true, Opcode.SPUT_OBJECT, Opcode.SPUT_OBJECT_VOLATILE), new FieldOpcode('[', true, Opcode.SPUT_OBJECT, Opcode.SPUT_OBJECT_VOLATILE), new FieldOpcode('Z', true, Opcode.SGET_BOOLEAN, Opcode.SGET_VOLATILE), new FieldOpcode('B', true, Opcode.SGET_BYTE, Opcode.SGET_VOLATILE), new FieldOpcode('S', true, Opcode.SGET_SHORT, Opcode.SGET_VOLATILE), new FieldOpcode('C', true, Opcode.SGET_CHAR, Opcode.SGET_VOLATILE), new FieldOpcode('I', true, Opcode.SGET, Opcode.SGET_VOLATILE), new FieldOpcode('F', true, Opcode.SGET, Opcode.SGET_VOLATILE), new FieldOpcode('J', true, Opcode.SGET_WIDE, Opcode.SGET_WIDE_VOLATILE), new FieldOpcode('D', true, Opcode.SGET_WIDE, Opcode.SGET_WIDE_VOLATILE), new FieldOpcode('L', true, Opcode.SGET_OBJECT, Opcode.SGET_OBJECT_VOLATILE), new FieldOpcode('[', true, Opcode.SGET_OBJECT, Opcode.SGET_OBJECT_VOLATILE)};
    private static final FieldOpcode[] artFieldOpcodes = new FieldOpcode[]{new FieldOpcode('Z', Opcode.IGET_BOOLEAN, Opcode.IGET_BOOLEAN_QUICK), new FieldOpcode('B', Opcode.IGET_BYTE, Opcode.IGET_BYTE_QUICK), new FieldOpcode('S', Opcode.IGET_SHORT, Opcode.IGET_SHORT_QUICK), new FieldOpcode('C', Opcode.IGET_CHAR, Opcode.IGET_CHAR_QUICK), new FieldOpcode('I', Opcode.IGET, Opcode.IGET_QUICK), new FieldOpcode('F', Opcode.IGET, Opcode.IGET_QUICK), new FieldOpcode('J', Opcode.IGET_WIDE, Opcode.IGET_WIDE_QUICK), new FieldOpcode('D', Opcode.IGET_WIDE, Opcode.IGET_WIDE_QUICK), new FieldOpcode('L', Opcode.IGET_OBJECT, Opcode.IGET_OBJECT_QUICK), new FieldOpcode('[', Opcode.IGET_OBJECT, Opcode.IGET_OBJECT_QUICK), new FieldOpcode('Z', Opcode.IPUT_BOOLEAN, Opcode.IPUT_BOOLEAN_QUICK), new FieldOpcode('B', Opcode.IPUT_BYTE, Opcode.IPUT_BYTE_QUICK), new FieldOpcode('S', Opcode.IPUT_SHORT, Opcode.IPUT_SHORT_QUICK), new FieldOpcode('C', Opcode.IPUT_CHAR, Opcode.IPUT_CHAR_QUICK), new FieldOpcode('I', Opcode.IPUT, Opcode.IPUT_QUICK), new FieldOpcode('F', Opcode.IPUT, Opcode.IPUT_QUICK), new FieldOpcode('J', Opcode.IPUT_WIDE, Opcode.IPUT_WIDE_QUICK), new FieldOpcode('D', Opcode.IPUT_WIDE, Opcode.IPUT_WIDE_QUICK), new FieldOpcode('L', Opcode.IPUT_OBJECT, Opcode.IPUT_OBJECT_QUICK), new FieldOpcode('[', Opcode.IPUT_OBJECT, Opcode.IPUT_OBJECT_QUICK)};
    private final FieldOpcode[][][] opcodeMap = new FieldOpcode[2][2][10];
    private final Map<Opcode, Integer> opcodeValueTypeMap = new HashMap<Opcode, Integer>(30);

    private static int getValueType(char type) {
        switch (type) {
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0;
            }
            case 'D': 
            case 'J': {
                return 1;
            }
            case 'L': 
            case '[': {
                return 2;
            }
        }
        throw new RuntimeException(String.format("Unknown type %s: ", Character.valueOf(type)));
    }

    private static int getTypeIndex(char type) {
        switch (type) {
            case 'Z': {
                return 0;
            }
            case 'B': {
                return 1;
            }
            case 'S': {
                return 2;
            }
            case 'C': {
                return 3;
            }
            case 'I': {
                return 4;
            }
            case 'F': {
                return 5;
            }
            case 'J': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'L': {
                return 8;
            }
            case '[': {
                return 9;
            }
        }
        throw new RuntimeException(String.format("Unknown type %s: ", Character.valueOf(type)));
    }

    private static boolean isGet(@NonNull Opcode opcode) {
        if (opcode == null) {
            OdexedFieldInstructionMapper.$$$reportNull$$$0(0);
        }
        return (opcode.flags & 0x10) != 0;
    }

    private static boolean isStatic(@NonNull Opcode opcode) {
        if (opcode == null) {
            OdexedFieldInstructionMapper.$$$reportNull$$$0(1);
        }
        return (opcode.flags & 0x100) != 0;
    }

    public OdexedFieldInstructionMapper(boolean isArt) {
        FieldOpcode[] opcodes = isArt ? artFieldOpcodes : dalvikFieldOpcodes;
        for (FieldOpcode fieldOpcode : opcodes) {
            this.opcodeMap[OdexedFieldInstructionMapper.isGet((Opcode)fieldOpcode.normalOpcode) ? 0 : 1][OdexedFieldInstructionMapper.isStatic((Opcode)fieldOpcode.normalOpcode) ? 1 : 0][OdexedFieldInstructionMapper.getTypeIndex((char)fieldOpcode.type)] = fieldOpcode;
            if (fieldOpcode.quickOpcode != null) {
                this.opcodeValueTypeMap.put(fieldOpcode.quickOpcode, OdexedFieldInstructionMapper.getValueType(fieldOpcode.type));
            }
            if (fieldOpcode.volatileOpcode == null) continue;
            this.opcodeValueTypeMap.put(fieldOpcode.volatileOpcode, OdexedFieldInstructionMapper.getValueType(fieldOpcode.type));
        }
    }

    @NonNull
    public Opcode getAndCheckDeodexedOpcode(@NonNull String fieldType, @NonNull Opcode odexedOpcode) {
        if (fieldType == null) {
            OdexedFieldInstructionMapper.$$$reportNull$$$0(2);
        }
        if (odexedOpcode == null) {
            OdexedFieldInstructionMapper.$$$reportNull$$$0(3);
        }
        FieldOpcode fieldOpcode = this.opcodeMap[OdexedFieldInstructionMapper.isGet(odexedOpcode) ? 0 : 1][OdexedFieldInstructionMapper.isStatic(odexedOpcode) ? 1 : 0][OdexedFieldInstructionMapper.getTypeIndex(fieldType.charAt(0))];
        if (!this.isCompatible(odexedOpcode, fieldOpcode.type)) {
            throw new AnalysisException(String.format("Incorrect field type \"%s\" for %s", fieldType, odexedOpcode.name), new Object[0]);
        }
        Opcode opcode = fieldOpcode.normalOpcode;
        if (opcode == null) {
            OdexedFieldInstructionMapper.$$$reportNull$$$0(4);
        }
        return opcode;
    }

    private boolean isCompatible(Opcode opcode, char type) {
        Integer valueType = this.opcodeValueTypeMap.get((Object)opcode);
        if (valueType == null) {
            throw new RuntimeException("Unexpected opcode: " + opcode.name);
        }
        return valueType == OdexedFieldInstructionMapper.getValueType(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "odexedOpcode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/OdexedFieldInstructionMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/OdexedFieldInstructionMapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndCheckDeodexedOpcode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGet";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAndCheckDeodexedOpcode";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldOpcode {
        public final char type;
        public final boolean isStatic;
        @NonNull
        public final Opcode normalOpcode;
        @Nullable
        public final Opcode quickOpcode;
        @Nullable
        public final Opcode volatileOpcode;

        public FieldOpcode(char type, @NonNull Opcode normalOpcode, @Nullable Opcode quickOpcode, @Nullable Opcode volatileOpcode) {
            if (normalOpcode == null) {
                FieldOpcode.$$$reportNull$$$0(0);
            }
            this.type = type;
            this.isStatic = false;
            this.normalOpcode = normalOpcode;
            this.quickOpcode = quickOpcode;
            this.volatileOpcode = volatileOpcode;
        }

        public FieldOpcode(char type, boolean isStatic, @NonNull Opcode normalOpcode, @Nullable Opcode volatileOpcode) {
            if (normalOpcode == null) {
                FieldOpcode.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.isStatic = isStatic;
            this.normalOpcode = normalOpcode;
            this.quickOpcode = null;
            this.volatileOpcode = volatileOpcode;
        }

        public FieldOpcode(char type, @NonNull Opcode normalOpcode, @Nullable Opcode quickOpcode) {
            if (normalOpcode == null) {
                FieldOpcode.$$$reportNull$$$0(2);
            }
            this.type = type;
            this.isStatic = false;
            this.normalOpcode = normalOpcode;
            this.quickOpcode = quickOpcode;
            this.volatileOpcode = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "normalOpcode", "org/jf/dexlib2/analysis/OdexedFieldInstructionMapper$FieldOpcode", "<init>"));
        }
    }
}

