/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;

public class BuilderArrayPayload
extends BuilderInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    protected final int elementWidth;
    @NonNull
    protected final List<Number> arrayElements;

    public BuilderArrayPayload(int elementWidth, @Nullable List<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = elementWidth;
        this.arrayElements = arrayElements == null ? ImmutableList.of() : arrayElements;
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @NonNull
    public List<Number> getArrayElements() {
        List<Number> list = this.arrayElements;
        if (list == null) {
            BuilderArrayPayload.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.arrayElements.size() + 1) / 2;
    }

    @Override
    public Format getFormat() {
        return BuilderArrayPayload.OPCODE.format;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/builder/instruction/BuilderArrayPayload", "getArrayElements"));
    }
}

