/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.instruction;

import android.support.annotation.NonNull;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction22t
extends ImmutableInstruction
implements Instruction22t {
    public static final Format FORMAT = Format.Format22t;
    protected final int registerA;
    protected final int registerB;
    protected final int codeOffset;

    public ImmutableInstruction22t(@NonNull Opcode opcode, int registerA, int registerB, int codeOffset) {
        if (opcode == null) {
            ImmutableInstruction22t.$$$reportNull$$$0(0);
        }
        super(opcode);
        this.registerA = Preconditions.checkNibbleRegister(registerA);
        this.registerB = Preconditions.checkNibbleRegister(registerB);
        this.codeOffset = Preconditions.checkShortCodeOffset(codeOffset);
    }

    public static ImmutableInstruction22t of(Instruction22t instruction) {
        if (instruction instanceof ImmutableInstruction22t) {
            return (ImmutableInstruction22t)instruction;
        }
        return new ImmutableInstruction22t(instruction.getOpcode(), instruction.getRegisterA(), instruction.getRegisterB(), instruction.getCodeOffset());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getCodeOffset() {
        return this.codeOffset;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "opcode", "org/jf/dexlib2/immutable/instruction/ImmutableInstruction22t", "<init>"));
    }
}

