/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.PrintStream;
import java.text.BreakIterator;
import java.util.Iterator;
import org.jf.util.ConsoleUtil;

public class StringWrapper {
    public static Iterable<String> wrapStringOnBreaks(final @NonNull String string, final int maxWidth) {
        if (string == null) {
            StringWrapper.$$$reportNull$$$0(0);
        }
        final BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int currentLineStart = 0;
                    private boolean nextLineSet = false;
                    private String nextLine;

                    @Override
                    public boolean hasNext() {
                        if (!this.nextLineSet) {
                            this.calculateNext();
                        }
                        return this.nextLine != null;
                    }

                    private void calculateNext() {
                        int lineEnd;
                        block5: {
                            lineEnd = this.currentLineStart;
                            do {
                                if ((lineEnd = breakIterator.following(lineEnd)) == -1) {
                                    lineEnd = breakIterator.last();
                                    if (lineEnd <= this.currentLineStart) {
                                        this.nextLine = null;
                                        this.nextLineSet = true;
                                        return;
                                    }
                                } else {
                                    if (lineEnd - this.currentLineStart <= maxWidth) continue;
                                    if ((lineEnd = breakIterator.preceding(lineEnd)) <= this.currentLineStart) {
                                        lineEnd = this.currentLineStart + maxWidth;
                                    }
                                }
                                break block5;
                            } while (string.charAt(lineEnd - 1) != '\n');
                            this.nextLine = string.substring(this.currentLineStart, lineEnd - 1);
                            this.nextLineSet = true;
                            this.currentLineStart = lineEnd;
                            return;
                        }
                        this.nextLine = string.substring(this.currentLineStart, lineEnd);
                        this.nextLineSet = true;
                        this.currentLineStart = lineEnd;
                    }

                    @Override
                    public String next() {
                        String ret = this.nextLine;
                        this.nextLine = null;
                        this.nextLineSet = false;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String[] wrapString(@NonNull String str, int maxWidth, @Nullable String[] output) {
        int i;
        if (str == null) {
            StringWrapper.$$$reportNull$$$0(1);
        }
        if (output == null) {
            output = new String[(int)((double)(str.length() / maxWidth) * 1.5 + 1.0)];
        }
        int lineStart = 0;
        int arrayIndex = 0;
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                output = StringWrapper.addString(output, str.substring(lineStart, i), arrayIndex++);
                lineStart = i + 1;
                continue;
            }
            if (i - lineStart != maxWidth) continue;
            output = StringWrapper.addString(output, str.substring(lineStart, i), arrayIndex++);
            lineStart = i;
        }
        if (lineStart != i || i == 0) {
            output = StringWrapper.addString(output, str.substring(lineStart), arrayIndex++, output.length + 1);
        }
        if (arrayIndex < output.length) {
            output[arrayIndex] = null;
        }
        return output;
    }

    private static String[] addString(@NonNull String[] arr, String str, int index) {
        if (arr == null) {
            StringWrapper.$$$reportNull$$$0(2);
        }
        if (index >= arr.length) {
            arr = StringWrapper.enlargeArray(arr, (int)Math.ceil((double)(arr.length + 1) * 1.5));
        }
        arr[index] = str;
        return arr;
    }

    private static String[] addString(@NonNull String[] arr, String str, int index, int newLength) {
        if (arr == null) {
            StringWrapper.$$$reportNull$$$0(3);
        }
        if (index >= arr.length) {
            arr = StringWrapper.enlargeArray(arr, newLength);
        }
        arr[index] = str;
        return arr;
    }

    private static String[] enlargeArray(String[] arr, int newLength) {
        String[] newArr = new String[newLength];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    public static void printWrappedString(@NonNull PrintStream stream, @NonNull String string) {
        if (stream == null) {
            StringWrapper.$$$reportNull$$$0(4);
        }
        if (string == null) {
            StringWrapper.$$$reportNull$$$0(5);
        }
        StringWrapper.printWrappedString(stream, string, ConsoleUtil.getConsoleWidth());
    }

    public static void printWrappedString(@NonNull PrintStream stream, @NonNull String string, int maxWidth) {
        if (stream == null) {
            StringWrapper.$$$reportNull$$$0(6);
        }
        if (string == null) {
            StringWrapper.$$$reportNull$$$0(7);
        }
        for (String str : StringWrapper.wrapStringOnBreaks(string, maxWidth)) {
            stream.println(str);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "org/jf/util/StringWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapStringOnBreaks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "printWrappedString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

