/*
 * Copyright 2014, Google Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.jf.util;

import android.support.annotation.NonNull;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtils {
    private static String newline = System.getProperty("line.separator");

    @NonNull
    public static String normalizeNewlines(@NonNull String source) {
        return normalizeNewlines(source, newline);
    }

    @NonNull
    public static String normalizeNewlines(@NonNull String source, String newlineValue) {
        return source.replace("\r", "").replace("\n", newlineValue);
    }

    @NonNull
    public static String normalizeWhitespace(@NonNull String source) {
        // Go to native system new lines so that ^/$ work correctly
        source = normalizeNewlines(source);

        // Remove all suffix/prefix whitespace
        Pattern pattern = Pattern.compile("((^[ \t]+)|([ \t]+$))", Pattern.MULTILINE);
        Matcher matcher = pattern.matcher(source);
        source = matcher.replaceAll("");

        // Remove all empty lines
        Pattern pattern2 = Pattern.compile("^\r?\n?", Pattern.MULTILINE);
        Matcher matcher2 = pattern2.matcher(source);
        source = matcher2.replaceAll("");

        // Remove a trailing new line, if present
        Pattern pattern3 = Pattern.compile("\r?\n?$");
        Matcher matcher3 = pattern3.matcher(source);
        source = matcher3.replaceAll("");

        // Go back to unix-style \n newlines
        source = normalizeNewlines(source, "\n");
        return source;
    }

    @NonNull
    public static String stripComments(@NonNull String source) {
        Pattern pattern = Pattern.compile("#(.*)");
        Matcher matcher = pattern.matcher(source);
        return matcher.replaceAll("");
    }
}
