<?php

/**
 *
 * @wordpress-plugin
 * Plugin Name:       e-addons PDF
 * Plugin URI:        https://e-addons.com
 * Description:       Create your PDF documents from Elementor Templates
 * Version:           2.0
 * Author:            Nerds Farm
 * Author URI:        https://nerds.farm
 * Text Domain:       e-addons-pdf
 * Domain Path:       /languages
 * License:           GPL-3.0
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package e-addons
 * @category Pdf
 *
 */
// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Load Elements
 *
 * Load the plugin after Elementor (and other plugins) are loaded.
 *
 * @since 0.1.0
 */
add_action('e_addons/loaded', function() {
    // Require the main plugin file
    require_once( __DIR__ . DIRECTORY_SEPARATOR . 'core' . DIRECTORY_SEPARATOR . 'plugin.php' );
    $plugin = new \EAddonsPdf\Plugin();
});
add_action('plugins_loaded', function() {
    if (!function_exists('e_addons_load_plugin')) {
        add_action('admin_notices', function() {
            $message = esc_html__('You need to activate "Elementor Free" and "e-addons Free" in order to use "e-addons PDF" plugin.', 'elementor');
            echo '<div class="notice notice-error"><p>' . $message . '</p></div>';
        });
    }
}, 11);

// ACTIVATION
function e_addons_pdf_activate() {
    add_option( 'e_addons_pdf_activate', true );
}
register_activation_hook(__FILE__, 'e_addons_pdf_activate');
function e_addons_pdf_load_plugin() {
    if ( is_admin() && get_option( 'e_addons_pdf_activate' ) ) {
        delete_option( 'e_addons_pdf_activate' );
        /* do stuff once right after activation */
        $current_plugin_name = basename(__FILE__,".php");
        \EAddonsForElementor\Plugin::instance()->update_vendors($current_plugin_name);
    }
}
add_action( 'admin_init', 'e_addons_pdf_load_plugin' );

// UPDATE
function e_addons_pdf_upgrade($upgrader_object, $options) {
    $current_plugin_path_name = plugin_basename(__FILE__);    
    if ($options['action'] == 'update' && $options['type'] == 'plugin') {
        foreach ($options['plugins'] as $each_plugin) {
            if ($each_plugin == $current_plugin_path_name) {
                $current_plugin_name = basename(__FILE__,".php");
                \EAddonsForElementor\Plugin::instance()->update_vendors($current_plugin_name);
            }
        }
    }
}
add_action('upgrader_process_complete', 'e_addons_pdf_upgrade', 10, 2);