<?php

namespace EAddonsPdf\Modules\Pdf;

use EAddonsForElementor\Base\Module_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Pdf extends Module_Base {
    
    /**
     * Dimensions of paper sizes in points
     *
     * @var array;
     */
    static $PAPER_SIZES = [
        "4a0", "2a0", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10", 
        "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "b10", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10", 
        "ra0", "ra1", "ra2", "ra3", "ra4", "sra0", "sra1", "sra2","sra3", "sra4","letter","half-letter", "legal","ledger","tabloid","executive",
        "folio", "commercial #10 envelope", "catalog #10 1/2 envelope", "8.5x11", "8.5x14", "11x17",
    ];

    public function __construct() {
        parent::__construct();
        //add_action('elementor_pro/init', [$this, 'after_init_actions'], 11);  
    }

    /**
     * Get Name
     *
     * Return the module name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'pdf';
    }
    
    public static function get_paper_sizes() {
        $paper_sizes = self::$PAPER_SIZES;
        $tmp = array();
        foreach ($paper_sizes as $asize) {
            $tmp[$asize] = strtoupper($asize);
        }
        $paper_sizes = $tmp;
        return $paper_sizes;
    }
    
    public function after_init_actions() {
        $form_action = \ElementorPro\Plugin::instance()->modules_manager->get_modules('forms')->get_form_actions(); //->get_component('form_actions'); //$this->get_name());
        if (!empty($form_action['pdf'])) {
            if (!empty($form_action['email'])) {
                //var_dump($form_action); die();
            }
        }
    }

}
