<?php

namespace EAddonsPdf\Modules\Pdf\Traits;

use EAddonsForElementor\Core\Utils;
use Elementor\Controls_Manager;

/**
 * Description of Pdf trait
 *
 */
trait Pdf {
    
    public function add_common_pdf_controls($widget = null) {
        
        if (!$widget) {
            $widget = $this;
        }
                
        $widget->add_control(
                'e_pdf_orientation', [
            'label' => esc_html__('Orientation', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'portrait' => [
                    'title' => esc_html__('Portrait', 'e-addons'),
                    'icon' => 'eicon-v-align-stretch',
                ],
                'landscape' => [
                    'title' => esc_html__('Landscape', 'e-addons'),
                    'icon' => 'eicon-h-align-stretch',
                ]
            ],
            'toggle' => false,
            'default' => 'portrait',
                ]
        );
        $widget->add_control(
                'e_pdf_margin', [
            'label' => esc_html__('Margin', 'e-addons'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['mm'], // 'px', '%', 'em'],
                /* 'condition' => [
                  'e_form_pdf_body' => 'text',
                  ] */
                ]
        );
        
        $widget->add_control(
                'e_pdf_rtl',
                [
                    'label' => esc_html__('Is RTL', 'e-addons'),
                    'type' => Controls_Manager::SWITCHER,
                ]
        );
        $widget->add_control(
                'e_pdf_auto_lang_to_font',
                [
                    'label' => esc_html__('Automatic Font', 'e-addons'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'description' => esc_html__('Automatically selects the font to use, based on the HTML lang attribute. Disable it if you apply a Custom Font.'),
                ]
        );
        
    }
    
    public function add_bg_controls($widget = null) {
        
        if (!$widget) {
            $widget = $this;
        }
        
        $widget->add_control(
                'e_pdf_background_color',
                [
                    'label' => esc_html__('Background Color', 'elementor'),
                    'type' => Controls_Manager::COLOR,
                ]
        );
        $widget->add_control(
                'e_pdf_background_image',
                [
                    'label' => esc_html__('Background Image', 'elementor'),
                    'type' => Controls_Manager::MEDIA,
                ]
        );

        $widget->add_control(
                'e_pdf_watermark',
                [
                    'label' => esc_html__('Watermark', 'e-addons'),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_enable', [
            'label' => esc_html__('Enable watermark', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_text', [
            'label' => esc_html__('Watermark text', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'condition' => [
                'e_pdf_watermark_enable!' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_rotation', [
            'label' => esc_html__('Watermark Text Rotation', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'description' => esc_html__('Enter your required rotation (in degree) for Watermark text'),
            'condition' => [
                'e_watermark_enable!' => '',
                'e_pdf_watermark_text!' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image',
                [
                    'label' => esc_html__('Watermark Image', 'elementor'),
                    'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'e_pdf_watermark_enable!' => '',
                    ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_size', [
            'label' => esc_html__('Watermark Image Size', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => array('D' => 'Original size of image', 'P' => 'Resize to fit the full page size, keeping aspect ratio', 'F' => 'Resize to fit the print-area (frame) respecting current page margins, keeping aspect ratio', 'INT' => 'Resize to full page size minus a margin set by this integer, keeping aspect ratio', 'array' => 'Specify Width and Height'),
            'default' => 'D',
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_size_width', [
            'label' => esc_html__('Watermark Image Size Width', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
                'e_pdf_watermark_image_size' => 'array',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_size_height', [
            'label' => esc_html__('Watermark Image Size Height', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
                'e_pdf_watermark_image_size' => 'array',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_size_int', [
            'label' => esc_html__('Watermark Image Size Integer', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
                'e_pdf_watermark_image_size' => 'INT',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_position', [
            'label' => esc_html__('Watermark Image Position', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'P' => 'Centred on the whole page area', 
                'F' => 'Centred on the page print-area (frame) respecting page margins', 
                'array' => 'Specify a position'
            ),
            'default' => 'P',
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_position_x', [
            'label' => esc_html__('Watermark Image Horizontal Position', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
                'e_pdf_watermark_image_position' => 'array',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_image_position_y', [
            'label' => esc_html__('Watermark Image Vertical Position', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'condition' => [
                'e_pdf_watermark_enable!' => '',
                'e_pdf_watermark_image[id]!' => ['', []],
                'e_pdf_watermark_image_position' => 'array',
            ],
                ]
        );
        $widget->add_control(
                'e_pdf_watermark_opacity', [
            'label' => esc_html__('Watermark opacity', 'e-addons'),
            'type' => Controls_Manager::NUMBER,
            'step' => "0.1",
            'min' => 0,
            'max' => 1,
            'default' => 0.2,
            'description' => esc_html__('Select the opacity for Watermark'),
            'condition' => [
                'e_pdf_watermark_enable!' => '',
            ],
                ]
        );
    }
    
    
    
    
}
