<?php
/**
 * Pro features for Blocks.
 */
namespace EDD\Blocks\Pro;

defined( 'ABSPATH' ) || exit;

/**
 * Initialize the Pro features.
 *
 * @since 2.0.6
 * @return void
 */
function init() {
	$pro_files = array(
		'search',
	);

	$files_to_require = array();
	foreach ( $pro_files as $file ) {
		$files_to_require[] = trailingslashit( EDD_BLOCKS_DIR . 'pro' ) . $file . '.php';
	}

	$integrations = array(
		'eddMultiCurrency' => 'multicurrency',
	);
	foreach ( $integrations as $function_exists => $file ) {
		if ( function_exists( $function_exists ) ) {
			$files_to_require[] = trailingslashit( EDD_BLOCKS_DIR . 'pro/integrations' ) . $file . '.php';
		}
	}

	foreach ( $files_to_require as $file ) {
		if ( file_exists( $file ) ) {
			require_once $file;
		}
	}
}
