<?php
/**
 * License Upgrade Notice
 *
 * @package   easy-digital-downloads
 * @copyright Copyright (c) 2023, Easy Digital Downloads
 * @license   GPL2+
 * @since     3.1.1
 */

namespace EDD\Pro\Admin\Promos\Notices;

class InactivePro extends \EDD\Admin\Promos\Notices\License_Upgrade_Notice {

	/**
	 * Sets the notice to not be dismissible.
	 */
	const DISMISSIBLE = false;

	/**
	 * @inheritDoc
	 *
	 * @return bool
	 */
	protected function _should_display() {

		if ( $this->meets_never_display_conditions() ) {
			return false;
		}

		return true;
	}

	/**
	 * @inheritDoc
	 * @since 3.1.1
	 * @return array
	 */
	protected function get_css_classes() {
		$css_classes   = parent::get_css_classes();
		$css_classes[] = 'edd-pro-inactive';

		return $css_classes;
	}

	/**
	 * @inheritDoc
	 */
	protected function _display() {

		$link_url = edd_get_admin_url(
			array(
				'page' => 'edd-settings',
			)
		);

		printf(
			wp_kses_post(
				/* Translators: %1$s opening anchor tag; %2$s closing anchor tag */
				__( 'You are using Easy Digital Downloads (Pro) without an active license key. %1$sEnter or activate your license key now.%2$s', 'easy-digital-downloads' )
			),
			'<a href="' . esc_url( $link_url ) . '">',
			'</a>'
		);
	}
}
