<?php
/**
 * Promo Handler
 *
 * Handles logic for displaying and dismissing promotional notices.
 *
 * @package   easy-digital-downloads
 * @copyright Copyright (c) 2023, Easy Digital Downloads
 * @license   GPL2+
 * @since     3.1.1
 */

namespace EDD\Pro\Admin\Promos;

class PromoHandler extends \EDD\Admin\Promos\PromoHandler {

	/**
	 * Gets the notices.
	 * This method overrides the parent method if an inactive pro install is detected.
	 *
	 * @return void
	 */
	protected function get_notices() {
		if ( ! edd_is_inactive_pro() ) {
			return $this->notices;
		}

		$license_upgrade_notice_key = array_search( '\\EDD\\Admin\\Promos\\Notices\\License_Upgrade_Notice', $this->notices, true );
		if ( ! is_null( $license_upgrade_notice_key ) ) {
			$this->notices[ $license_upgrade_notice_key ] = '\\EDD\\Pro\\Admin\\Promos\\Notices\\InactivePro';
		}

		return $this->notices;
	}
}
