<?php

/**
 * Base class for adding pro event subscribers.
 *
 * @package EDD
 */
namespace EDD\Pro;

class Core extends \EDD\Core {

	/**
	 * Gets the service providers for EDD.
	 *
	 * @return array
	 */
	protected function get_service_providers() {
		return array_merge( parent::get_service_providers(), $this->get_pro_providers() );
	}

	/**
	 * Gets the admin service providers.
	 *
	 * @since 3.1.1
	 * @return array
	 */
	protected function get_admin_providers() {
		return $this->get_pro_admin_providers();
	}

	/**
	 * Gets providers that may be extended/replaced in lite/pro.
	 *
	 * @return array
	 */
	protected function get_replaceable_providers() {
		return array(
			new Admin\Extensions\Legacy(),
			new Admin\Promos\PromoHandler(),
		);
	}

	/**
	 * Gets the pro providers.
	 *
	 * @since 3.1.1
	 * @return array
	 */
	private function get_pro_providers() {
		return array(
			new Admin\PassHandler\Ajax( $this->pass_handler ),
			new Admin\PassHandler\Cron(),
			new Checkout\GeoIP(),
			new Licensing\Update(),
			new Translations\Translate(),
		);
	}

	/**
	 * Gets the pro admin providers.
	 *
	 * @since 3.1.1
	 * @return array
	 */
	private function get_pro_admin_providers() {
		if ( ! is_admin() ) {
			return array();
		}
		$providers = parent::get_admin_providers();

		return array_merge(
			$providers,
			array(
				new Admin\Duplicator\Controls(),
				new Admin\Duplicator\Worker(),
			)
		);
	}
}
