<?php

/**
 * Class SupsysticTablesPro_Diagram_Controller
 */
class SupsysticTablesPro_Diagram_Controller extends SupsysticTables_Core_BaseController
{
    /**
     * @var \SupsysticTablesPro_Diagram_Model_Diagrams
     */
    private $diagrams;

    /**
     * {@inheritdoc}
     */
    public function __construct(
        RscDtgs_Environment $environment,
        RscDtgs_Http_Request $request
    )
    {
        parent::__construct(
            $environment,
            $request
        );

        $this->diagrams = $this->getModel('diagrams', 'diagram');
    }

    /**
     * Saves the diagram.
     * @param \RscDtgs_Http_Request $request
     * @return \RscDtgs_Http_Response
     */
    public function saveAction(RscDtgs_Http_Request $request)
    {
        $data = $request->post->get(array('data', 'table_id'));

		// if (get_magic_quotes_gpc()) {
			//$data = stripslashes($data);
		// }
        try {
            $id = $this->diagrams->add($data);

            return $this->ajaxSuccess(array('id' => (int)$id));
        } catch (Exception $e) {
            return $this->ajaxError($e->getMessage());
        }
    }

    /**
     * Removes the diagram.
     * @param \RscDtgs_Http_Request $request
     * @return \RscDtgs_Http_Response
     */
    public function removeAction(RscDtgs_Http_Request $request)
    {
        $id = (int)$request->post->get('id');

        try {
            $this->diagrams->removeById($id);

            return $this->ajaxSuccess();
        } catch (RuntimeException $e) {
            return $this->ajaxError($e->getMessage());
        }
    }

	/**
	* Update the diagram.
	* @param \RscDtgs_Http_Request $request
	* @return \RscDtgs_Http_Response
	*/
	public function updateAction(RscDtgs_Http_Request $request)
	{
		$id = (int)$request->post->get('id');
		$data['data'] = $request->post->get('data');

		// if (get_magic_quotes_gpc()) {
			//$data = stripslashes($data);
		// }

		try {
			$this->diagrams->set($id, $data);
			return $this->ajaxSuccess();
		} catch (RuntimeException $e) {
			return $this->ajaxError($e->getMessage());
		}
	}
}
