<?php

/**
 * Class SupsysticTablesPro_Exporter_Module
 */
class SupsysticTablesPro_Exporter_Module extends SupsysticTables_Core_BaseModule
{
    /**
     * {@inheritdoc}
     */
    public function onInit()
    {
        $this->setOverloadController(true);

        $this->loadPartials();
        $this->onAfterUiLoaded();
        $this->addExportFeature();

        add_action('init', array($this, 'handleExportRequest'));
        //$this->handleExportRequest();
    }

    /**
     * Returns the list of the supported export formats.
     * @return array
     */
    public function getSupportedFormats()
    {
        $dispatcher = $this->getEnvironment()->getDispatcher();

        return $dispatcher->apply('supported-export-formats',
            array(
                array(
                    'CSV' 					=> 'csv',
                    'MS Excel 2003 (.xls)' 	=> 'xls',
                    'MS Excel 2007 (.xlsx)' => 'xlsx',
                    'PDF' 					=> 'pdf',
                    'Print' 				=> 'print',
					'Email' 				=> 'email'
                )
            )
        );
    }

	private function loadPartials()
	{
		$dispatcher = $this->getEnvironment()->getDispatcher();
		$dispatcher->on('tables-view-footer', array($this, 'renderExportDialog'));
	}

    public function renderExportDialog()
    {
        $twig = $this->getEnvironment()->getTwig();

        $twig->display('@exporter/partials/export-dialog.twig');
    }

	private function addExportFeature()
	{
		$dispatcher = $this->getEnvironment()->getDispatcher();
		$dispatcher->on('tables-view-features', array($this, 'renderExportFeatures'));
	}

    public function renderExportFeatures($table)
    {
        $twig = $this->getEnvironment()->getTwig();
        $twig->display('@exporter/features/export.twig', array('table' => $table));
    }

	public function handleExportRequest()
	{
		if (!$this->getRequest()->query->has('export-supsystic-table')
			&& !$this->getRequest()->post->has('pdf-table-data')
		) {
			return;
		}
		$config = $this->getEnvironment()->getConfig();
		$path = $config->get('pro_modules_path');
		$type = $this->getRequest()->query->get_esc_html('type');

		if ('pdf' === $type
			&& !version_compare($phpVersion = phpversion(), '5.3.0', '>=')
		) {
			wp_die(sprintf($this->getEnvironment()->translate('PDF export requires PHP 5.3+, your version %s'), $phpVersion));
		}

		if (!class_exists('PhpOffice\PhpSpreadsheet\Spreadsheet')) {
			require_once dirname($path) . '/vendor/PHPOffice/PhpSpreadsheet/Spreadsheet.php';
		}

		if ('pdf' === $type && !class_exists('DOMPDF')) {
			// require_once dirname($path) . '/vendor/dompdf/autoload.inc.php';
		}
		$this->getController()->export($this->getRequest());
	}

    private function onAfterUiLoaded()
    {
        $version = $this->getConfig()->get('plugin_version_pro');
        $location = untrailingslashit(plugin_dir_url(__FILE__));
		$hookName = is_admin() ? 'admin_enqueue_scripts' : 'wp_enqueue_scripts';

		/** @var SupsysticTables_Ui_Module $ui */
		$ui = $this->getEnvironment()->getModule('ui');

		if ($this->getEnvironment()->isModule('tables', 'view')) {
			$ui->add(
				$ui->createStyle('supsystic-tables-exporter-backend')
					->setHookName('admin_enqueue_scripts')
					->setExternalSource($location . '/assets/css/exporter.backend.css')
					->setVersion($version)
			);

			$ui->add(
				$ui->createScript('jquery-ui-dialog')
					->setHookName('admin_enqueue_scripts')
			);

			$ui->add(
				$ui->createScript('supsystic-tables-view-exporter-js')
					->setHookName('admin_enqueue_scripts')
					->setModuleSource($this, 'js/tables.view.exporter.js')
					->setVersion($version)
			);
		}

		$ui->add(
			$ui->createScript('supsystic-tables-exporter-js')
				->setHookName($hookName)
				->setModuleSource($this, 'js/exporter.js')
				->setVersion($version)
		);
    }
}
