(function ($, app, undefined) {
	var media;

	$(document).ready(function () {
		var $exportDialog = $('#exportDialog').dialog({
			modal:   true,
			width:   600,
			autoOpen: false,
			buttons: {
				Export: function () {
					var id = app.getParameterByName('id'),
						type = $('.export-type').filter(':checked').val();

					if(type == 'pdf') {
						var orientation = $('#features-export-pdf-orientation').val(),
							paperSize = $('#features-export-pdf-paper-size').val(),
							exportFonts = $('#features-export-pdf-export-fonts').is(':checked') ? 'on' : '',
							fullWidth = $('#features-export-pdf-full-width').is(':checked') ? 'on' : '',
							container = $('#stbPdfExportContainer'),
							tableData = $('#table-preview').html();

						// to prevent init two tables with the same id
						$('#table-preview').empty();
						app.removeAllTableInstances();

						if(!container.length) {
							$('.supsystic-container').append('<div id="stbPdfExportContainer"></div>');
							container = $('#stbPdfExportContainer');
						}
						app.Models.Tables.render(id).done(function(response) {
							container.empty().append($(response.table));

							var table = container.find('#supsystic-table-' + id);

							app.initializeTable(table, app.showTable, function(table) {
								var params = {
									type: type,
									href: location.pathname + '?export-supsystic-table=true&type=' + type + '&id=' + id + '&nonce=' + DTGS_NONCE,
									element: table,
									columns: table.find('tr:first th').length,
									paper_size: paperSize,
									orientation: orientation,
									full_width: fullWidth
								};
								app.applyTableEventClb(stbExportTable, 50, params, app, function() {
									container.empty();
									$exportDialog.dialog('close');
                                    $('#table-preview').html(tableData);
								});
							});
						});
					} else {
						app.request({
							module: 'exporter',
							action: 'generateUrl',
                     nonce: DTGS_NONCE,
						}, {
							id: id,
							type: type
						}).done(function (response) {
							window.location.href = response.url;
						}).fail(function (message) {
							alert(message);
						}).always(function () {
							$exportDialog.dialog('close');
						});
					}
				},
				Cancel: function () {
					$(this).dialog('close');
				}
			}
		});

		$('#export').on('click', function () {
			if(g_stbDoSaving === false && g_stbDoPreview === false) {
				$exportDialog.dialog('open');
			}
		});

		$('.select-logo').on('click', function(event) {
			event.preventDefault();
			var $this = $(this);
			if (typeof media === "undefined") {
				media = window.wp.media();
				media.on('select', function () {
					var attachment = media.state().get('selection').first().toJSON();
					stbSelectLogo(attachment.url);
				});
			}
			media.open();
		});

		$('.remove-logo').on('click', function(event) {
			event.preventDefault();
			stbRemoveLogo();
		});
	});
	function stbSelectLogo(url) {
		var $tr = $('.setting-export-logo');

		$tr.addClass('selected');
		$tr.find('.export-logo-img img').attr('src', url);
		$tr.find('[name="exportLogo[src]"]').val(url);
		$tr.find('.export-logo-img').show(300);
		$tr.find('.remove-logo').show(300);
		$tr.find('.select-logo').hide(300);
		$tr.find('label').attr('for', $tr.find('.remove-logo').attr('id'));
		$('.export-logo-options').show(300);
	}
	function stbRemoveLogo() {
		var $tr = $('.setting-export-logo');

		$tr.removeClass('selected');
		$tr.find('[name="exportLogo[src]"]').val('');
		$tr.find('.export-logo-img').hide(300);
		$tr.find('.remove-logo').hide(300);
		$tr.find('.select-logo').show(300);
		$tr.find('label').attr('for', $tr.find('.select-logo').attr('id'));
		$('.export-logo-options').hide(300);
	}
}(window.jQuery, window.supsystic.Tables));
