<?php


class SupsysticTablesPro_License_Controller extends SupsysticTables_Core_BaseController
{
    public function indexAction(RscDtgs_Http_Request $request)
    {
        $helper = $this->getHelper();
        $options = $this->getOptions();
        if(!$helper->isActive($options)) {
            return $this->response(
                '@license/index.twig'
            );
        } else {
            $daysLeft = $options->get('license_days_left');
            $date = date("Y-m-d");
            $dateLeft = date( "Y-m-d", strtotime( "$date +$daysLeft day" ) );
            return $this->response(
                '@license/active.twig',
                array('days' => $daysLeft, 'dateLeft' => $dateLeft)
            );
        }
    }

    public function activateAction(RscDtgs_Http_Request $request) {
        $data = $request->post->all();
        $options = $this->getOptions();
        $status = false;
		$errors = array();

        if($this->getHelper()->activate($data, $options)) {
            $status = true;
		} else {
			$errors = $this->getHelper()->getErrors();
        }

        return $this->response(RscDtgs_Http_Response::AJAX, array('status' => $status, 'errors' => $errors));
    }

    protected function getOptions()
    {
        return $this->getModule('license')->getOptions();
    }

    protected function getHelper()
    {
        return $this->getModule('license')->getHelper();
    }
	public function dismissNoticeAction(RscDtgs_Http_Request $request) {
		$this->getOptions()->save('dismiss_pro_opt', 1);	// Just save it
	}
}
