(function ($, app, undefined) {
	$(document).ready(function () {
		$('#export-group').on('click', function() {

			var selectedRowIds = jQuery('#ddtTableTbl').jqGrid ('getGridParam', 'selarrrow')
			,	listIds = [];
			for(var i in selectedRowIds) {
				var rowData = jQuery('#ddtTableTbl').jqGrid('getRowData', selectedRowIds[ i ]);
				listIds.push( rowData.id );
			}

			app.request({
				module: 'migration',
				action: 'generateUrl',
            nonce: DTGS_NONCE,
			}, {
				id: listIds.join(';')
			}).done(function (response) {
				window.location.href = response.url;
			}).fail(function (message) {
				alert(message);
			});
			return false;
		});

		var $error = $('#importErrorMsg'),
			$importDialog = $('#stbMigrationDialog').dialog({
				modal:    true,
				autoOpen: false,
				width:    600,
				buttons: {
					Import: function () {
						$error.fadeOut();

						if (!$('input[name="file"]').val()) {
							$error.text('You need to choose the file!');
							$error.fadeIn();
							return;
						}
						$importDialog.find('form').submit();
					},
					Cancel: function () {
						$(this).dialog('close');
					}
				}
			});
		$('#import-group').on('click', function () {
			$importDialog.dialog('open');
		});
	});
}(window.jQuery, window.supsystic.Tables));
