(function ($, app) {
	$(document).ready(function() {
		var editor = app.Editor.Hot,
			condition = new app.Editor._Conditions($('#conditionalFormattingDialog'));

		app.Editor.Conditions = condition;

		// Custom Handsontabe Renderers
		Handsontable.renderers.DefaultProRenderer = function(instance,td,row,col,prop,value,cellProperties) {
			Handsontable.renderers.DefaultRenderer.call(this,instance,td,row,col,prop,value,cellProperties);
			condition.setConditionToCell(row, col, value, td);
		};

		// Editor Hooks
		editor.addHook('afterLoadData', function () {
			editor.updateSettings({
				renderer: Handsontable.renderers.DefaultProRenderer,
				height: $('.ht_master .wtHider').height()
			});
		});
		editor.addHook('afterContextMenuDefaultOptions', function(predefinedItems) {
			predefinedItems.items.push(
				{
					key: 2,
					name: '---------'
				},
				{
					key: 'conditionFormatting',
					name: function() {
						return 'Conditional formatting...';
					},
					callback: function(name, selection, e) {
						g_stbConditionsDialog.dialog('open');
					},
					disabled: function() {
						return false;
					}
				},
			);
		});
	});
})(window.jQuery, window.supsystic.Tables);