jQuery(document).ready(function($) {
    // ------------------------
    // Initialize all
    // ------------------------
    initProductControls();
    initCartControls();
    initCheckout();
    initFilters();

    // ------------------------
    // Product Controls
    // ------------------------
    function initProductControls() {
        jQuery(document).on('click', '.single-product a.u-btn.u-product-control', function (e) {
            if (!this.attributes.href) {
                e.preventDefault();
                jQuery('.single-product button.single_add_to_cart_button').click();
            }
        });

        jQuery(document).on('click', '.u-product .u-btn.u-product-control', function(e) {
            e.preventDefault();
            jQuery(this).parents('.u-product').find('.single_add_to_cart_button').click();
        });

        // Change variation options
        changeVariationOptions();

        var firstPriceHandled = false;
        jQuery(document).on('show_variation', '.single_variation_wrap', function() {
            if (firstPriceHandled) {
                return;
            }

            if (jQuery('.woocommerce-variation-price').length) {
                changePrice();
                firstPriceHandled = true;
            } else {
                setTimeout(function(){
                    if(jQuery('.woocommerce-variation-price').length) {
                        changePrice();
                        firstPriceHandled = true;
                    }
                }, 50);
            }
        });

        jQuery(document).on('change', '.u-product-variant select', function() {
            setTimeout(changePrice, 500);
        });

        // variation images
        jQuery('form.variations_form').on('change', 'input.variation_id', function() {
            var variation_id = jQuery('input.variation_id').val();
            if (variation_id) {
                var variation_data = jQuery('form.variations_form').data('product_variations').find(function(variation) {
                    return variation.variation_id == variation_id;
                });

                if (variation_data && variation_data.image) {
                    if (jQuery('.u-carousel').length && jQuery('.u-carousel').data('bs.u-carousel')) {
                        jQuery('.u-carousel').data('bs.u-carousel').pause();
                    }
                    jQuery('.woocommerce-product-gallery__image.u-active img').attr('src', variation_data.image.src);
                    jQuery('.woocommerce-product-gallery__image.u-active .u-back-slide').each(function() {
                        var $backSlide = jQuery(this);
                        if ($backSlide.css('background-image') !== 'none') {
                            $backSlide.css('background-image', 'url("' + variation_data.image.src + '")');
                        }
                    });
                    jQuery('.u-carousel-thumbnails img').each(function(index, element) {
                        if (index === 0) {
                            jQuery(element).attr('src', variation_data.image.src);
                        }
                    });
                }
            }
        });

        // Quantity
        changeQuantity();
        jQuery(document).on('change', '.u-quantity-input', changeQuantity);
    }

    // ------------------------
    // Cart
    // ------------------------
    function initCartControls() {
        jQuery('body').on('click', '.u-cart-remove-item', function (e) {
            jQuery(this).parents('td').find('.remove')[0].click();
        });
        jQuery('body').on('click', '.u-cart-update', function (e) {
            e.preventDefault();
            jQuery(this).parents('.u-cart').find('.np-cart-update').click();
        });
        jQuery('body').on('change', '.u-cart-form .u-input', function () {
            jQuery('#coupon_code').val(jQuery(this).val());
        });
        jQuery('.u-cart-form a.u-btn-submit').on('click', function (e) {
            e.preventDefault();
            jQuery('.coupon .button').click();
        });
    }

    // ------------------------
    // Checkout
    // ------------------------
    function initCheckout() {
        if (!jQuery('form.woocommerce-checkout').length) {
            return;
        }

        jQuery('form.woocommerce-checkout').on('checkout_place_order', function () {
            prepareCheckoutForm();
            return true;
        });
        jQuery('body').on('change', '.u-checkout-form form :input', prepareCheckoutForm);
        jQuery('body').on('change', '.u-checkout-form-order :input:not(.shipping_method)', prepareCheckoutForm);
        prepareCheckoutForm();
        // Shipping Address fields
        jQuery('div.shipping_address').hide();
        jQuery('body').on('change', '#ship-to-different-address input', function () {
            jQuery('div.shipping_address').hide();
            if (jQuery(this).is(':checked') ) {
                jQuery('div.shipping_address').slideDown();
            }
        });
        jQuery('body').on('change', 'input[name^="shipping_method"]', function () {
            jQuery('.u-checkout-placeorder-form form .data-from-checkout-form .shipping_method').removeAttr('checked').prop('checked', false);
            jQuery('.u-checkout-placeorder-form form .data-from-checkout-form .shipping_method[value="'+ jQuery(this).val() + '"]').attr('checked', '').prop('checked', true);
            jQuery(document.body).trigger("update_checkout");
        });

        jQuery(document.body).on('country_to_state_changed', fixStateFieldClasses);
    }

    // ------------------------
    // Filters
    // ------------------------
    function initFilters() {
        // sidebar widget - filter by attribute
        if (jQuery('.widget-filter-wrapper').length) {
            jQuery('body').on( "click", '.widget-filter-wrapper input[type=checkbox], .widget-filter-wrapper input[type=radio]', function() {
                var filterUrl = jQuery(this).parent().find('.u-field-label').attr('data-href');
                if (filterUrl) {
                    document.location.href = filterUrl;
                }
            });
        }
        // sorting
        jQuery('[data-products-datasource="cms"] .u-select-sorting').change(function() {
            let selectedOption = $(this).children("option:selected").val();
            let url = new URL(window.location.href);
            let params = new URLSearchParams(url.search);
            params.delete('sorting');
            params.append('sorting', selectedOption);
            url.search = params.toString();
            let newUrl = url.toString();
            if (newUrl) {
                window.location.href = newUrl;
            }
        });
        // categories filter
        jQuery('[data-products-datasource="cms"] .u-select-categories').change(function() {
            var type = 'default';
            if (jQuery(this).closest('.u-products').length && jQuery(this).closest('.u-products').attr('data-control-in-template')) {
                type = 'control-in-template';
            }
            var categoriesFilterUrl = jQuery(this).children("option:selected").val();
            if (type === 'default') {
                if (categoriesFilterUrl) {
                    document.location.href = categoriesFilterUrl;
                }
            } else {
                let url = new URL(window.location.href);
                let params = new URLSearchParams(url.search);
                params.delete('categoryId');
                params.append('categoryId', categoriesFilterUrl);
                url.search = params.toString();
                let newUrl = url.toString();
                if (newUrl) {
                    window.location.href = newUrl;
                }
            }
        });
    }
});

// ------------------------
// Utils
// ------------------------
function changePrice() {
    if (!jQuery('.woocommerce-variation-price').length) {
        return;
    }

    var priceControl = jQuery('.u-product-price:visible');
    if (priceControl.length > 1) {
        priceControl.each(function(index) {
            if (index === 0) { return; }
            priceControl[index].remove();
        });
    }
    if (jQuery('.woocommerce-variation-price .price ins').not(':visible').length && jQuery('.woocommerce-variation-price .price del').not(':visible').length) {
        priceControl.find('.u-price').html(jQuery('.woocommerce-variation-price .price ins').not(':visible').html());
        priceControl.find('.u-old-price').html(jQuery('.woocommerce-variation-price .price del').not(':visible').html());
    } else {
        priceControl.html(jQuery('.woocommerce-variation-price .u-product-price').not(':visible').html());
    }
}

function changeQuantity() {
    var quantityWoocommerceInput = jQuery('input[name="quantity"]')
    if (quantityWoocommerceInput.length) {
        quantityWoocommerceInput.val(jQuery(this).find('.u-input').val());
    }
}

function prepareCheckoutForm() {
    jQuery(document.body).trigger("update_checkout");
    jQuery('.u-checkout-placeorder-form form .data-from-checkout-form').html('');
    jQuery('.u-checkout-form form').find(':input').clone().appendTo('.u-checkout-placeorder-form form .data-from-checkout-form');
    jQuery('.u-checkout-form-order').find(':input').clone().appendTo('.u-checkout-placeorder-form form .data-from-checkout-form');
    var selects = jQuery('.u-checkout-form select');
    var id = '';
    for (let i = 0; i < selects.length; i++) {
        id = selects.eq(i).attr('id');
        var selectsTo = jQuery('.u-checkout-placeorder-form #' + id);
        var selectsFrom = jQuery('.u-checkout-form #' + id);
        if (id && selectsTo.length && selectsFrom.length) {
            selectsTo[0].selectedIndex = selectsFrom[0].selectedIndex;
        }
    }
}

function changeVariationOptions() {
    var variationForm = jQuery('.variations_form');
    variationForm.on('show_variation', function(event, variation, purchasable) {
        if (variation.sku) {
            jQuery('.u-product-control.u-product-sku').text(variation.sku);
        }
        if (variation.variation_description) {
            var variationDesc = jQuery('.variations_form div.u-product-control.np-variation-desc');
            if (variationDesc.length) {
                variationDesc.html(variation.variation_description);
            } else {
                jQuery('.u-product-variations:last').after(jQuery('div.u-product-control.u-text').eq(0).clone().html(variation.variation_description).addClass('np-variation-desc'));
            }
        }
    });
}

function fixStateFieldClasses() {
    var selectClasses = jQuery('#billing_country_field select').attr('class');
    jQuery('#billing_state_field select').attr('class', selectClasses.replace('country', 'state'));
}

function submitCheckoutForm() {
    jQuery('button#place_order').click();
}
