<?php

namespace WPFormsActiveCampaign\Api\V3\Endpoints;

use WPFormsActiveCampaign\Api\V3\Http\Response;

/**
 * Class Lists.
 *
 * @see   https://developers.activecampaign.com/reference#lists
 *
 * @since 1.0.0
 */
class Lists extends Resource {

	/**
	 * Create a list.
	 *
	 * @see   https://developers.activecampaign.com/reference#create-new-list
	 *
	 * @since 1.0.0
	 *
	 * @param array $list List data.
	 *
	 * @return Response|\WP_Error
	 */
	public function create( $list ) {

		return $this->client
			->get_client()
			->post(
				'/lists',
				[
					'body' => [
						'list' => $list,
					],
				]
			);
	}

	/**
	 * Retrieve all lists or a list when id is not null.
	 *
	 * @see   https://developers.activecampaign.com/reference#retrieve-a-list
	 *
	 * @since 1.0.0
	 *
	 * @param null|string $id           List ID.
	 * @param array       $query_params Query params.
	 *
	 * @return Response|\WP_Error
	 */
	public function retrieve( $id = null, $query_params = [] ) {

		$uri = '/lists';

		if ( null !== $id ) {
			$uri .= '/' . $id;
		}

		$query_params = wp_parse_args( $query_params, [ 'limit' => $this->limit ] );

		return $this->client
			->get_client()
			->get(
				$uri,
				[
					'query' => $query_params,
				]
			);
	}

	/**
	 * Delete a list.
	 *
	 * @see   https://developers.activecampaign.com/reference#delete-a-list
	 *
	 * @since 1.0.0
	 *
	 * @param string $id List ID.
	 *
	 * @return Response|\WP_Error
	 */
	public function delete( $id ) {

		return $this->client
			->get_client()
			->delete( '/lists/' . $id );
	}
}
