<?php

namespace WPFormsActiveCampaign\Api\V3\Endpoints;

use WPFormsActiveCampaign\Api\V3\Http\Response;

/**
 * Class Notes.
 *
 * @see   https://developers.activecampaign.com/reference#notes
 *
 * @since 1.0.0
 */
class Notes extends Resource {

	/**
	 * Create a note.
	 *
	 * @see   https://developers.activecampaign.com/reference#create-a-note
	 *
	 * @since 1.0.0
	 *
	 * @param array $note New note data.
	 *
	 * @return Response|\WP_Error
	 */
	public function create( $note ) {

		return $this->client
			->get_client()
			->post(
				'/notes',
				[
					'body' => [
						'note' => $note,
					],
				]
			);
	}
}
