<?php

namespace WPFormsActiveCampaign\Api\V3\Endpoints;

use WPFormsActiveCampaign\Api\V3\Client;

/**
 * Class for resources.
 *
 * @since 1.0.0
 */
class Resource {

	/**
	 * Current client.
	 *
	 * @since 1.0.0
	 *
	 * @var Client
	 */
	protected $client;

	/**
	 * Number of records to return.
	 * By default API returns 20. We raise it to 100.
	 *
	 * @since 1.1.0
	 *
	 * @var int
	 */
	protected $limit = 100;

	/**
	 * Resource constructor.
	 *
	 * @since 1.0.0
	 *
	 * @param Client $client Client to perform requests on behalf of.
	 */
	public function __construct( $client ) {

		$this->client = $client;
	}
}
