<?php

namespace WPFormsActiveCampaign\Api\V3\Endpoints;

use WPFormsActiveCampaign\Api\V3\Http\Response;

/**
 * Class Tags.
 *
 * @see   https://developers.activecampaign.com/reference#tags
 *
 * @since 1.0.0
 */
class Tags extends Resource {

	/**
	 * List all tags.
	 *
	 * @see   https://developers.activecampaign.com/reference#retrieve-all-tags
	 *
	 * @since 1.0.0
	 *
	 * @param array $query_params Query params.
	 *
	 * @return Response|\WP_Error
	 */
	public function listAll( $query_params = [] ) {

		$query_params = wp_parse_args( $query_params, [ 'limit' => $this->limit ] );

		return $this->client
			->get_client()
			->get(
				'/tags',
				[
					'query' => $query_params,
				]
			);
	}

	/**
	 * Create a tag.
	 *
	 * @see   https://developers.activecampaign.com/reference#create-a-new-tag
	 *
	 * @since 1.0.0
	 *
	 * @param array $tag New tag data.
	 *
	 * @return Response|\WP_Error
	 */
	public function create( $tag ) {

		$tag = wp_parse_args(
			$tag,
			[
				'tagType'     => 'contact',
				'description' => '',
			]
		);

		return $this->client
			->get_client()
			->post(
				'/tags',
				[
					'body' => [
						'tag' => $tag,
					],
				]
			);
	}
}
