<?php

namespace WPFormsActiveCampaign\Api\V3\Endpoints;

use WPFormsActiveCampaign\Api\V3\Http\Response;

/**
 * Class Users.
 *
 * @see   https://developers.activecampaign.com/reference#users
 *
 * @since 1.0.0
 */
class Users extends Resource {

	/**
	 * Retrieve a user.
	 *
	 * @see   https://developers.activecampaign.com/reference#get-user
	 *
	 * @since 1.0.0
	 *
	 * @param int $id ID of the user you want to view.
	 *
	 * @return Response|\WP_Error
	 */
	public function get( $id ) {

		return $this->client
			->get_client()
			->get( '/users/' . $id );
	}

	/**
	 * List all users.
	 *
	 * @see   https://developers.activecampaign.com/reference#list-all-users
	 *
	 * @since 1.0.0
	 *
	 * @return Response|\WP_Error
	 */
	public function list_all() {

		return $this->client
			->get_client()
			->get( '/users' );
	}

	/**
	 * Retrieve the logged-in user.
	 *
	 * @see   https://developers.activecampaign.com/reference#get-contact
	 *
	 * @since 1.0.0
	 *
	 * @return Response|\WP_Error
	 */
	public function me() {

		return $this->client
			->get_client()
			->get( '/users/me' );
	}
}
