<?php

namespace WPFormsActiveCampaign;

use WPForms\Providers\Providers;

/**
 * Class Plugin that loads the whole plugin.
 *
 * @since 1.0.0
 */
class Plugin {

	/**
	 * Plugin constructor.
	 *
	 * @since 1.0.0
	 */
	private function __construct() {

		$this->hooks();

		Providers::get_instance()->register(
			Provider\Core::get_instance()
		);
	}

	/**
	 * Get a single instance of the addon.
	 *
	 * @since 1.0.0
	 *
	 * @return \WPFormsActiveCampaign\Plugin
	 */
	public static function get_instance() {

		static $instance;

		if ( ! $instance ) {
			$instance = new Plugin();
		}

		return $instance;
	}

	/**
	 * Hooks.
	 *
	 * @since 1.0.0
	 */
	protected function hooks() {

		add_action( 'update_option_wpforms_providers', [ $this, 'flush_cache' ] );
		add_action( 'wpforms_updater', [ $this, 'updater' ] );
	}

	/**
	 * Flash a transient cache on providers data change.
	 *
	 * @since 1.0.0
	 */
	public function flush_cache() {

		// Call it when account was added or disconnected.
		if (
			did_action( 'wp_ajax_wpforms_settings_provider_add_activecampaign' ) ||
			did_action( 'wp_ajax_wpforms_settings_provider_disconnect_activecampaign' )
		) {
			delete_transient( 'wpforms_providers_activecampaign_ajax_accounts_get' );
		}
	}

	/**
	 * Load the addon updater.
	 *
	 * @since 1.0.0
	 *
	 * @param string $key License key.
	 */
	public function updater( $key ) {

		new \WPForms_Updater(
			array(
				'plugin_name' => 'WPForms ActiveCampaign',
				'plugin_slug' => 'wpforms-activecampaign',
				'plugin_path' => plugin_basename( WPFORMS_ACTIVECAMPAIGN_FILE ),
				'plugin_url'  => trailingslashit( WPFORMS_ACTIVECAMPAIGN_URL ),
				'remote_url'  => WPFORMS_UPDATER_API,
				'version'     => WPFORMS_ACTIVECAMPAIGN_VERSION,
				'key'         => $key,
			)
		);
	}
}
