<?php

namespace WPFormsActiveCampaign\Provider;

/**
 * Class Core registers all the handlers for
 * Form Builder, Settings > Integrations page, Processing etc.
 *
 * @since 1.0.0
 */
class Core extends \WPForms\Providers\Provider\Core {

	/**
	 * Priority for a provider, that will affect loading/placement order.
	 *
	 * @since 1.0.0
	 */
	const PRIORITY = 11;

	/**
	 * Core constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		parent::__construct(
			array(
				'slug' => 'activecampaign',
				'name' => esc_html__( 'ActiveCampaign', 'wpforms-activecampaign' ),
				'icon' => WPFORMS_ACTIVECAMPAIGN_URL . 'assets/images/addon-icon.png',
			)
		);
	}

	/**
	 * Provide an instance of the object, that should process the submitted entry.
	 * It will use data from an already saved entry to pass it further to a Provider.
	 *
	 * @since 1.0.0
	 *
	 * @return null|\WPFormsActiveCampaign\Provider\Process
	 */
	public function get_process() {

		static $process;

		if ( ! $process ) {
			$process = new Process( static::get_instance() );
		}

		return $process;
	}

	/**
	 * Provide an instance of the object, that should display provider settings
	 * on Settings > Integrations page in admin area.
	 *
	 * @since 1.0.0
	 *
	 * @return null|\WPFormsActiveCampaign\Provider\PageIntegrations
	 */
	public function get_page_integrations() {

		static $integration;

		if ( ! $integration ) {
			$integration = new PageIntegrations( static::get_instance() );
		}

		return $integration;
	}

	/**
	 * Provide an instance of the object, that should display provider settings in the Form Builder.
	 *
	 * @since 1.0.0
	 *
	 * @return null|\WPFormsActiveCampaign\Provider\FormBuilder
	 */
	public function get_form_builder() {

		static $builder;

		if ( ! $builder ) {
			$builder = new FormBuilder( static::get_instance() );
		}

		return $builder;
	}

	/**
	 * Get the form inputs needed to add a new provider account.
	 * Used both in the Form Builder and Settings > Integrations page.
	 *
	 * @since 1.0.0
	 *
	 * @return string $html HTML of the template.
	 */
	public static function get_add_new_account_fields_html() {

		$core_name     = static::get_instance()->name;
		$template_path = WPFORMS_ACTIVECAMPAIGN_PATH . 'templates/settings/new-account-connection.php';
		$html          = '';

		if ( is_readable( $template_path ) ) {
			ob_start();
			require_once $template_path;
			$html = ob_get_clean();
		}

		return $html;
	}
}
