<?php
/**
 * Translatable provider name.
 *
 * @var string $label
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<li class="wpforms-clear">
	<span class="label"><?php echo esc_html( $label ); ?></span>
	<span class="date">
		<?php
		/* translators: %s - Connection date. */
		printf( esc_html__( 'Connected on: %s', 'wpforms-activecampaign' ), date_i18n( get_option( 'date_format' ), time() ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		?>
	</span>
	<span class="remove">
		<a href="#"
			data-provider="<?php echo esc_attr( $this->core->slug ); ?>"
			data-key="<?php echo esc_attr( $key ); ?>">
			<?php esc_html_e( 'Disconnect', 'wpforms-activecampaign' ); ?>
		</a>
	</span>
</li>
