<?php
/**
 * Account name.
 *
 * @var string $account_name
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<input type="text" name="actid" class="wpforms-required"
	placeholder="<?php esc_attr_e( 'Event Tracking Account ID *', 'wpforms-activecampaign' ); ?>">
<input type="text" name="event_key" class="wpforms-required"
	placeholder="<?php esc_attr_e( 'Event Tracking Key *', 'wpforms-activecampaign' ); ?>">

<p class="description">
	<?php
	printf(
		wp_kses(
			/* translators: %1$s - ActiveCampaign account name; %2$s - URL to the ActiveCampaign User Info page. */
			__( 'Event Tracking must be enabled for "%1$s" account. Please go to ActiveCampaign account on Settings > Tracking > Event Tracking. More details <a href="%2$s" target="_blank" rel="noopener noreferrer">here</a>.', 'wpforms-activecampaign' ),
			[
				'a' => [
					'href'   => [],
					'target' => [],
					'rel'    => [],
				],
			]
		),
		esc_html( $account_name ),
		'https://help.activecampaign.com/hc/en-us/articles/221870128-An-overview-of-Event-Tracking'
	);
	?>
</p>

<p class="error hidden">
	<?php esc_html_e( 'Please make sure that Event Tracking Account ID and Key are correct.', 'wpforms-activecampaign' ); ?>
</p>
