<?php
/**
 * Translatable provider name.
 *
 * @var string $core_name
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<input type="text" name="acc_name" class="wpforms-required"
	placeholder="<?php printf( /* translators: %s - current provider name. */ esc_attr__( '%s Account Name', 'wpforms-activecampaign' ), esc_html( $core_name ) ); ?>">

<input type="text" name="api_url" class="wpforms-required"
	placeholder="<?php printf( /* translators: %s - current provider name. */ esc_attr__( '%s API URL *', 'wpforms-activecampaign' ), esc_html( $core_name ) ); ?>">

<input type="text" name="api_key" class="wpforms-required"
	placeholder="<?php printf( /* translators: %s - current provider name. */ esc_attr__( '%s API Key *', 'wpforms-activecampaign' ), esc_html( $core_name ) ); ?>">

<input type="text" name="actid" class="wpforms-required"
	placeholder="<?php esc_attr_e( 'Event Tracking Account ID', 'wpforms-activecampaign' ); ?>">

<input type="text" name="event_key" class="wpforms-required"
	placeholder="<?php esc_attr_e( 'Event Tracking Key', 'wpforms-activecampaign' ); ?>">

<p class="description">
	<?php
	printf(
		wp_kses(
			/* translators: %s - URL to the ActiveCampaign Getting started page. */
			__( 'The API URL and API Key can be found in your ActiveCampaign account settings. <a href="%s" target="_blank" rel="noopener noreferrer">Learn More</a>.', 'wpforms-activecampaign' ),
			[
				'a' => [
					'href'   => [],
					'target' => [],
					'rel'    => [],
				],
			]
		),
		esc_url( wpforms_utm_link( 'https://wpforms.com/docs/how-to-install-and-use-the-activecampaign-addon-with-wpforms/#initial-setup', 'Integration Settings', 'ActiveCampaign Documentation' ) )
	);
	?>
</p>

<p class="description">
	<?php
	printf(
		wp_kses(
			/* translators: %s - URL to the ActiveCampaign Getting started page. */
			__( 'The Event Tracking must be enabled in your ActiveCampaign tracking settings. <a href="%s" target="_blank" rel="noopener noreferrer">Learn More</a>.', 'wpforms-activecampaign' ),
			[
				'a' => [
					'href'   => [],
					'target' => [],
					'rel'    => [],
				],
			]
		),
		esc_url( wpforms_utm_link( 'https://wpforms.com/docs/how-to-install-and-use-the-activecampaign-addon-with-wpforms/#event-tracking', 'Integration Settings', 'ActiveCampaign Documentation' ) )
	);
	?>
</p>

<p class="error hidden">
	<?php esc_html_e( 'Something went wrong while performing an AJAX request.', 'wpforms-activecampaign' ); ?>
</p>
