<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wpforms-builder-provider-connection" data-connection_id="{{ data.connection.id }}">
	<input type="hidden" class="wpforms-builder-provider-connection-option_id"
			name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][option_id]"
			value="{{ data.connection.option_id }}">

	<div class="wpforms-builder-provider-connection-title">
		{{ data.connection.name }}

		<button class="wpforms-builder-provider-connection-delete js-wpforms-builder-provider-connection-delete" type="button">
			<i class="fa fa-trash-o"></i>
		</button>

		<input type="hidden"
				id="wpforms-builder-activecampaign-provider-%connection_id%-name"
				name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][name]"
				value="{{ data.connection.name }}">
	</div>

	<div class="wpforms-builder-provider-connection-block wpforms-builder-activecampaign-provider-accounts">
		<h4><?php esc_html_e( 'Select Account', 'wpforms-activecampaign' ); ?><span class="required">*</span></h4>

		<div class="wpforms-builder-provider-connection-setting">
			<select class="js-wpforms-builder-activecampaign-provider-connection-account wpforms-required"
					id="wpforms-builder-activecampaign-provider-%connection_id%-account"
					<# if ( _.isEmpty( data.accounts ) ) { #>disabled<# } #>
					name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][account_id]">

				<option value="" selected disabled><?php esc_html_e( '--- Select Account ---', 'wpforms-activecampaign' ); ?></option>

				<# _.each( data.accounts, function( account, option_id ) { #>
					<option value="{{ option_id }}" data-option_id="{{ option_id }}" <# if ( _.isMatch( data.connection, {account_id: option_id} ) ) { #>selected="selected"<# } #>>
						{{ account.email }}
					</option>
				<# } ); #>
			</select>
		</div>
	</div>

	<# if ( ! _.isEmpty( data.accounts ) ) { #>
		<div class="wpforms-builder-provider-connection-block wpforms-builder-activecampaign-provider-actions">
			<h4><?php esc_html_e( 'Action To Perform', 'wpforms-activecampaign' ); ?><span class="required">*</span></h4>

			<div class="wpforms-builder-provider-connection-setting">
				<select class="wpforms-required js-wpforms-builder-activecampaign-provider-connection-action"
						id="wpforms-builder-activecampaign-provider-%connection_id%-action"
						name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][action]"
						<# if ( _.isEmpty( data.connection.account_id ) ) { #>disabled<# } #>>

					<option value="" selected disabled><?php esc_html_e( '--- Select Action ---', 'wpforms-activecampaign' ); ?></option>

					<option value="subscriber_subscribe" <# if ( 'subscriber_subscribe' === data.connection.action ) { #>selected="selected"<# } #>><?php esc_html_e( 'Subscriber: Create or Update', 'wpforms-activecampaign' ); ?></option>
					<option value="subscriber_unsubscribe" <# if ( 'subscriber_unsubscribe' === data.connection.action ) { #>selected="selected"<# } #>><?php esc_html_e( 'Subscriber: Unsubscribe', 'wpforms-activecampaign' ); ?></option>
					<option value="subscriber_delete" <# if ( 'subscriber_delete' === data.connection.action ) { #>selected="selected"<# } #>><?php esc_html_e( 'Subscriber: Delete', 'wpforms-activecampaign' ); ?></option>
					<option value="event_tracking" <# if ( 'event_tracking' === data.connection.action ) { #>selected="selected"<# } #>><?php esc_html_e( 'Event Tracking', 'wpforms-activecampaign' ); ?></option>
				</select>
			</div>
		</div>
	<# } #>

	<!-- Here is where sub-templates will put its compiled HTML. -->
	<div class="wpforms-builder-activecampaign-provider-actions-data"></div>

	<# if ( ! _.isEmpty( data.accounts ) ) { #>
		{{{ data.conditional }}}
	<# } #>
</div>
