<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wpforms-builder-provider-connection-block wpforms-builder-activecampaign-provider-event-tracking">
	<div class="wpforms-builder-provider-connection-setting">
		<?php $this->display_email_field(); ?>
	</div>

	<p>
		<?php esc_html_e( 'If a contact does not exist in your ActiveCampaign account, the contact will be created and the event for it will be recorded.', 'wpforms-activecampaign' ); ?>
	</p>

	<div class="wpforms-builder-provider-connection-settings-group">
		<h4><?php esc_html_e( 'Custom Events', 'wpforms-activecampaign' ); ?></h4>

		<p><?php esc_html_e( 'Select one of the existing events:', 'wpforms-activecampaign' ); ?></p>

		<div class="wpforms-builder-provider-connection-setting">
			<select class="js-wpforms-builder-activecampaign-provider-item-select"
					id="wpforms-builder-activecampaign-provider-%connection_id%-event"
					<# if ( _.isEmpty(data.events) ) { #>disabled<# } #>
					name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][events][name]">

				<# if ( _.isEmpty( data.events ) ) { #><option value="" selected disabled><?php esc_html_e( '--- No Events ---', 'wpforms-activecampaign' ); ?></option><# } else { #><option value="" selected disabled><?php esc_html_e( '--- Select Saved Events ---', 'wpforms-activecampaign' ); ?></option><# } #>

				<# _.each( data.events, function( event, key ) { #>
					<option value="{{ event }}" <# if (  _.isMatch( data.connection.events, {name: event} ) ) { #>selected="selected"<# } #>>
						{{ event }}
					</option>
				<# } ); #>

			</select>

			<p class="text-btn-inlined">
				<span class="text-btn-inlined-text">
					<?php esc_html_e( 'or', 'wpforms-activecampaign' ); ?>
				</span>
				<button class="button-secondary text-btn-inlined-btn js-wpforms-builder-activecampaign-provider-add-new-item" type="button">
					<?php esc_html_e( 'Add New', 'wpforms-activecampaign' ); ?>
				</button>
			</p>
		</div>

		<div class="wpforms-builder-provider-connection-setting wpforms-builder-activecampaign-provider-item-input wpforms-hidden">
			<input type="text" value=""
					id="wpforms-builder-activecampaign-provider-%connection_id%-events-new"
					name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][events][new]"
					placeholder="<?php esc_attr_e( 'Your new custom event name', 'wpforms-activecampaign' ); ?>">

			<p class="description">
				<?php esc_html_e( 'Example: Submitted ActiveCampaign form', 'wpforms-activecampaign' ); ?>
			</p>
		</div>
	</div>

</div>
