<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wpforms-builder-provider-connection-block wpforms-builder-activecampaign-provider-subscriber-subscribe">
	<h4><?php esc_html_e( 'Create or Update Subscriber', 'wpforms-activecampaign' ); ?></h4>

	<div class="wpforms-builder-provider-connection-setting">
		<label for="wpforms-builder-activecampaign-provider-%connection_id%-lists">
			<?php esc_html_e( 'ActiveCampaign List', 'wpforms-activecampaign' ); ?><span class="required">*</span>
		</label>
		<select class="js-wpforms-builder-activecampaign-provider-connection-lists wpforms-required"
				id="wpforms-builder-activecampaign-provider-%connection_id%-lists"
				<# if ( _.isEmpty( data.lists ) ) { #>disabled<# } #>
				name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][list][id]">

			<# if ( _.isEmpty( data.lists ) ) { #><option value="" selected disabled><?php esc_html_e( '--- No Lists ---', 'wpforms-activecampaign' ); ?></option><# } else { #><option value="" selected disabled><?php esc_html_e( '--- Select List ---', 'wpforms-activecampaign' ); ?></option><# } #>

			<# _.each( data.lists, function( value, key, list ) { #>
			<option value="{{ key }}" <# if ( _.isMatch( data.connection.list, {id: key} ) ) { #>selected="selected"<# } #>>
				{{ value }}
			</option>
			<# } ); #>

		</select>

		<# if ( _.isEmpty( data.lists ) ) { #>
			<p class="description error-message">
				<?php esc_html_e( 'You have no lists yet. Consider creating at least one.', 'wpforms-activecampaign' ); ?>
			</p>
		<# } #>
	</div>

	<div class="wpforms-builder-provider-connection-setting">
		<?php $this->display_email_field(); ?>
	</div>

	<div class="wpforms-builder-provider-connection-setting">
		<?php $this->display_email_field( 'new' ); ?>
	</div>

	<div class="wpforms-builder-provider-connection-setting">
		<label for="wpforms-builder-activecampaign-provider-%connection_id%-status">
			<?php esc_html_e( 'Subscriber Status', 'wpforms-activecampaign' ); ?>
		</label>
		<select class="js-wpforms-builder-activecampaign-provider-connection-status"
				id="wpforms-builder-activecampaign-provider-%connection_id%-status"
				name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][subscribe_status][id]">
			<option value="" disabled><?php esc_html_e( '--- Select Status ---', 'wpforms-activecampaign' ); ?></option>
			<option value="0" <# if ( _.isMatch( data.connection.subscribe_status, {id: 0} ) ) { #>selected="selected"<# } #>><?php esc_html_e( 'Unconfirmed', 'wpforms-activecampaign' ); ?></option>
			<option value="1" <# if ( _.isMatch( data.connection.subscribe_status, {id: 1} ) ) { #>selected="selected"<# } #>><?php esc_html_e( 'Active', 'wpforms-activecampaign' ); ?></option>
		</select>
	</div>

	<div class="wpforms-builder-provider-connection-settings-group wpforms-builder-activecampaign-provider-subscriber-subscribe-tags">
		<div class="wpforms-builder-provider-connection-setting wpforms-builder-activecampaign-provider-subscriber-subscribe-tags-add">
			<label for="wpforms-builder-activecampaign-provider-%connection_id%-subscriber-subscribe-tags-add">
				<?php esc_html_e( 'Tags To Add', 'wpforms-activecampaign' ); ?>
			</label>
			<select
				id="wpforms-builder-activecampaign-provider-%connection_id%-subscriber-subscribe-tags-add"
				class="choicesjs-select"
				name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][tags][add][]"
				multiple>

					<# if ( _.isEmpty( data.tags ) ) { #><option value="" disabled><?php esc_html_e( '--- No Tags ---', 'wpforms-activecampaign' ); ?></option><# } #>

					<# _.each( data.tags, function( value, key, list ) { #>
					<option value="{{ value }}" <# if ( ! _.isEmpty( data.connection.tags ) && _.find( data.connection.tags.add, function(tag){ return tag == value; }) ) { #>selected="selected"<# } #>>
						{{ value }}
					</option>
					<# } ); #>

			</select>
			<p class="description"><?php esc_html_e( 'Select one or more of the existing tags.', 'wpforms-activecampaign' ); ?></p>
		</div>

		<div class="wpforms-builder-provider-connection-setting wpforms-builder-activecampaign-provider-item-input">
			<label for="wpforms-builder-activecampaign-provider-%connection_id%-tags-new">
				<?php esc_html_e( 'New Tags to Add', 'wpforms-activecampaign' ); ?>
			</label>
			<input type="text" value=""
					id="wpforms-builder-activecampaign-provider-%connection_id%-tags-new"
					name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][tags][new]"
					placeholder="<?php esc_attr_e( 'Example: WPForms', 'wpforms-activecampaign' ); ?>">

			<p class="description">
				<?php esc_html_e( 'Enter new tag name(s). Comma-separated list of tags is accepted.', 'wpforms-activecampaign' ); ?>
			</p>
		</div>

		<div class="wpforms-builder-provider-connection-setting wpforms-builder-activecampaign-provider-subscriber-subscribe-tags-delete">
			<label for="wpforms-builder-activecampaign-provider-%connection_id%-subscriber-subscribe-tags-delete">
				<?php esc_html_e( 'Tags To Remove', 'wpforms-activecampaign' ); ?>
			</label>
			<select
				class="choicesjs-select"
				id="wpforms-builder-activecampaign-provider-%connection_id%-subscriber-subscribe-tags-delete"
				name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][tags][delete][]"
				multiple>

					<# if ( _.isEmpty( data.tags_delete ) ) { #><option value="" disabled><?php esc_html_e( '--- No Tags ---', 'wpforms-activecampaign' ); ?></option><# } #>

					<# _.each( data.tags_delete, function( value, key, list ) { #>
					<option value="{{ value }}" <# if ( ! _.isEmpty( data.connection.tags ) && _.find( data.connection.tags.delete, function(tag){ return tag == value; }) ) { #>selected="selected"<# } #>>
						{{ value }}
					</option>
					<# } ); #>
			</select>
			<p class="description"><?php esc_html_e( 'Select one or more of the existing tags.', 'wpforms-activecampaign' ); ?></p>
		</div>

	</div>

	<div class="wpforms-builder-provider-connection-setting wpforms-panel-field wpforms-panel-field-textarea">
		<label for="wpforms-builder-activecampaign-provider-%connection_id%-note">
			<?php esc_html_e( 'Note', 'wpforms-activecampaign' ); ?>
            <a href="#" class="toggle-smart-tag-display" data-type="all" data-fields>
                <i class="fa fa-tags"></i>
                <span><?php esc_html_e( 'Show Smart Tags', 'wpforms-activecampaign' ); ?></span>
            </a>
		</label>
		<textarea id="wpforms-builder-activecampaign-provider-%connection_id%-note" name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][note]" placeholder="<?php esc_attr_e( 'Enter a note', 'wpforms-activecampaign' ); ?>" rows="4"><# if ( ! _.isEmpty( data.connection.note ) ) { #>{{ data.connection.note }}<# } #></textarea>
		<p class="description">
			<?php
			printf(
				wp_kses(
					/* translators: %s - WPForms.com URL to the list of smart tags. */
					__( 'You can use <a href="%s" target="_blank" rel="noopener noreferrer">smart tags</a> in notes.', 'wpforms-activecampaign' ),
					[
						'a' => [
							'href'   => [],
							'target' => [],
							'rel'    => [],
						],
					]
				),
				'https://wpforms.com/docs/how-to-use-smart-tags-in-wpforms/'
			);
			?>
		</p>
	</div>

</div>
