<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wpforms-builder-provider-connection-block wpforms-builder-activecampaign-provider-subscriber-unsubscribe">
	<h4><?php esc_html_e( 'Unsubscribe', 'wpforms-activecampaign' ); ?></h4>

	<div class="wpforms-builder-provider-connection-setting">

		<p class="description before">
			<?php esc_html_e( 'Sometimes you may want to give your users the option to unsubscribe themselves from your list(s) using your own form.', 'wpforms-activecampaign' ); ?>
		</p>

		<label for="wpforms-builder-activecampaign-provider-%connection_id%-lists">
			<?php esc_html_e( 'ActiveCampaign List', 'wpforms-activecampaign' ); ?><span class="required">*</span>
		</label>
		<select class="wpforms-required"
				id="wpforms-builder-activecampaign-provider-%connection_id%-lists"
				<# if ( _.isEmpty( data.lists ) ) { #>disabled<# } #>
				name="providers[<?php echo esc_attr( $this->core->slug ); ?>][{{ data.connection.id }}][list][id]">

			<# if ( _.isEmpty( data.lists ) ) { #><option value="" selected disabled><?php esc_html_e( '--- No Lists ---', 'wpforms-activecampaign' ); ?></option><# } else { #><option value="" selected disabled><?php esc_html_e( '--- Select List ---', 'wpforms-activecampaign' ); ?></option><# } #>

			<# _.each( data.lists, function( value, key, list ) { #>
			<option value="{{ key }}" <# if ( _.isMatch( data.connection.list, {id: key} ) ) { #>selected="selected"<# } #>>
				{{ value }}
			</option>
			<# } ); #>

			<# if ( ! _.isEmpty( data.lists ) ) { #><option value="all" <# if ( _.isMatch( data.connection.list, {id: 'all'} ) ) { #>selected="selected"<# } #>><?php esc_html_e( 'All Lists', 'wpforms-activecampaign' ); ?></option><# } #>
		</select>

		<# if ( _.isEmpty( data.lists ) ) { #>
			<p class="description error-message">
				<?php esc_html_e( 'You have no lists yet. Consider creating at least one.', 'wpforms-activecampaign' ); ?>
			</p>
		<# } #>
	</div>

	<div class="wpforms-builder-provider-connection-setting">
		<!-- Subscriber Email -->
		<?php $this->display_email_field(); ?>
	</div>
</div>
